/*
 * Decompiled with CFR 0.152.
 */
package jdplus.x13.base.core.x11;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.linearfilters.IFiniteFilter;
import jdplus.toolkit.base.core.math.linearfilters.SymmetricFilter;
import jdplus.x13.base.core.x11.X11Context;
import jdplus.x13.base.core.x11.X11Kernel;
import jdplus.x13.base.core.x11.extremevaluecorrector.IExtremeValuesCorrector;
import jdplus.x13.base.core.x11.filter.AutomaticHenderson;
import jdplus.x13.base.core.x11.filter.DefaultSeasonalNormalizer;
import jdplus.x13.base.core.x11.filter.DummyFilter;
import jdplus.x13.base.core.x11.filter.MusgraveFilterFactory;
import jdplus.x13.base.core.x11.filter.X11SeasonalFilterProcessor;
import jdplus.x13.base.core.x11.filter.X11SeasonalFiltersFactory;
import jdplus.x13.base.core.x11.filter.X11TrendCycleFilterFactory;
import jdplus.x13.base.core.x11.filter.endpoints.AsymmetricEndPoints;
import lombok.Generated;

public class X11CStep {
    private DoubleSeq c1;
    private DoubleSeq c2;
    private DoubleSeq c4;
    private DoubleSeq c5a;
    private DoubleSeq c5;
    private DoubleSeq c6;
    private DoubleSeq c7;
    private DoubleSeq c9;
    private DoubleSeq c10a;
    private DoubleSeq c10;
    private DoubleSeq c11;
    private DoubleSeq c13;
    private DoubleSeq c17;
    private DoubleSeq c20;
    private DoubleSeq refSeries;
    private int c2drop;

    public void process(DoubleSeq refSeries, DoubleSeq input, X11Context context) {
        this.refSeries = refSeries;
        this.c1Step(context, input);
        this.c2Step(context);
        this.c4Step(context);
        this.c5Step(context);
        this.c6Step(context);
        this.c7Step(context);
        this.c9Step(context);
        this.cFinalStep(context);
    }

    private void c1Step(X11Context context, DoubleSeq input) {
        this.c1 = this.c1(context, input);
    }

    protected DoubleSeq c1(X11Context context, DoubleSeq input) {
        return context.remove(this.refSeries, input);
    }

    private void c2Step(X11Context context) {
        SymmetricFilter filter = X11TrendCycleFilterFactory.makeTrendFilter(context.getPeriod());
        this.c2drop = filter.length() / 2;
        double[] x = X11Kernel.table(this.c1.length() - 2 * this.c2drop, Double.NaN);
        DataBlock out = DataBlock.of((double[])x, (int)0, (int)x.length);
        filter.apply(this.c1, (DoubleSeq.Mutable)out);
        this.c2 = DoubleSeq.of((double[])x);
    }

    private void c4Step(X11Context context) {
        this.c4 = context.remove(this.c1.drop(this.c2drop, this.c2drop), this.c2);
    }

    private void c5Step(X11Context context) {
        if (context.isSeasonal()) {
            X11SeasonalFilterProcessor processor = X11SeasonalFiltersFactory.filter(context.getPeriod(), context.getInitialSeasonalFilter());
            this.c5a = processor.process(this.c4, context.getPosition(this.c2drop));
            this.c5 = DefaultSeasonalNormalizer.normalize(this.c5a, this.c2drop, context);
        } else {
            this.c5 = this.c5a = DummyFilter.filter(context.isMultiplicative(), this.c4);
        }
    }

    private void c6Step(X11Context context) {
        this.c6 = this.c6(context);
    }

    protected DoubleSeq c6(X11Context context) {
        return context.remove(this.c1, this.c5);
    }

    private void c7Step(X11Context context) {
        SymmetricFilter filter;
        if (context.isAutomaticHenderson()) {
            double icr = AutomaticHenderson.calcICR(context, this.c6);
            int filterLength = AutomaticHenderson.selectFilter(icr, context.getPeriod());
            filter = context.trendFilter(filterLength);
        } else {
            filter = context.trendFilter();
        }
        int ndrop = filter.length() / 2;
        double[] x = X11Kernel.table(this.c6.length(), Double.NaN);
        DataBlock out = DataBlock.of((double[])x, (int)ndrop, (int)(x.length - ndrop));
        filter.apply(this.c6, (DoubleSeq.Mutable)out);
        double r = MusgraveFilterFactory.findR(filter.length(), context.getPeriod());
        IFiniteFilter[] asymmetricFilter = context.asymmetricTrendFilters(filter, r);
        AsymmetricEndPoints aep = new AsymmetricEndPoints(asymmetricFilter, 0);
        aep.process(this.c6, DataBlock.of((double[])x));
        this.c7 = DoubleSeq.of((double[])x);
        if (context.isMultiplicative()) {
            this.c7 = X11Context.makePositivity(this.c7);
        }
    }

    private void c9Step(X11Context context) {
        this.c9 = context.remove(this.c1, this.c7);
    }

    private void cFinalStep(X11Context context) {
        if (context.isSeasonal()) {
            X11SeasonalFilterProcessor processor = X11SeasonalFiltersFactory.filter(context.getPeriod(), context.getFinalSeasonalFilter());
            this.c10a = processor.process(this.c9, context.getPosition(0));
            this.c10 = DefaultSeasonalNormalizer.normalize(this.c10a, 0, context);
        } else {
            this.c10 = this.c10a = DummyFilter.filter(context.isMultiplicative(), this.c9);
        }
        this.c11 = this.c11(context);
        this.c13 = context.remove(this.c11, this.c7);
        IExtremeValuesCorrector ecorr = context.getExtremeValuesCorrector();
        ecorr.analyse(this.c13, context.getPosition(0), context);
        this.c17 = ecorr.getObservationWeights();
        this.c20 = ecorr.getCorrectionFactors();
    }

    protected DoubleSeq c11(X11Context context) {
        return context.remove(this.refSeries, this.c10);
    }

    @Generated
    public DoubleSeq getC1() {
        return this.c1;
    }

    @Generated
    public DoubleSeq getC2() {
        return this.c2;
    }

    @Generated
    public DoubleSeq getC4() {
        return this.c4;
    }

    @Generated
    public DoubleSeq getC5a() {
        return this.c5a;
    }

    @Generated
    public DoubleSeq getC5() {
        return this.c5;
    }

    @Generated
    public DoubleSeq getC6() {
        return this.c6;
    }

    @Generated
    public DoubleSeq getC7() {
        return this.c7;
    }

    @Generated
    public DoubleSeq getC9() {
        return this.c9;
    }

    @Generated
    public DoubleSeq getC10a() {
        return this.c10a;
    }

    @Generated
    public DoubleSeq getC10() {
        return this.c10;
    }

    @Generated
    public DoubleSeq getC11() {
        return this.c11;
    }

    @Generated
    public DoubleSeq getC13() {
        return this.c13;
    }

    @Generated
    public DoubleSeq getC17() {
        return this.c17;
    }

    @Generated
    public DoubleSeq getC20() {
        return this.c20;
    }

    @Generated
    public DoubleSeq getRefSeries() {
        return this.refSeries;
    }

    @Generated
    public int getC2drop() {
        return this.c2drop;
    }
}

