/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.optimization.cmaes;

import fr.inria.optimization.cmaes.CMAEvolutionStrategy;
import fr.inria.optimization.cmaes.CMAOptions;
import java.io.Serializable;

public class CMAParameters
implements Serializable {
    private static final long serialVersionUID = -1305062342816588003L;
    int supplemented;
    int locked;
    int lambda;
    int mu;
    double mucov = -1.0;
    double mueff;
    double[] weights;
    double damps;
    double cs;
    double cc;
    double ccov = -1.0;
    double ccovsep;
    double chiN;
    int flgLambdaChanged = 0;
    RecombinationType recombinationType = RecombinationType.superlinear;

    public String check() {
        if (this.lambda <= 1) {
            return "offspring population size lambda must be greater than one, is " + this.lambda;
        }
        if (this.mu < 1) {
            return "parent number mu must be greater or equal to one, is " + this.mu;
        }
        if (this.mu > this.lambda) {
            return "parent number mu " + this.mu + " must be smaller or equal to offspring population size lambda " + this.lambda;
        }
        if (this.weights.length != this.mu) {
            return "number of recombination weights " + this.weights.length + " disagrees with parent number mu " + this.mu;
        }
        if (this.cs <= 0.0 || this.cs > 1.0) {
            return "0 < cs <= 1 must hold for step-size cumulation parameter cs, is " + this.cs;
        }
        if (this.damps <= 0.0) {
            return "step-size damping parameter damps must be greater than zero, is " + this.damps;
        }
        if (this.cc <= 0.0 || this.cc > 1.0) {
            return "0 < cc <= 1 must hold for cumulation parameter cc, is " + this.cc;
        }
        if (this.mucov < 0.0) {
            return "mucov >= 0 must hold, is " + this.mucov;
        }
        if (this.ccov < 0.0) {
            return "learning parameter ccov >= 0 must hold, is " + this.ccov;
        }
        return "";
    }

    public CMAParameters getDefaults(int N) {
        if (N == 0) {
            this.error("default parameters needs dimension been set");
        }
        CMAParameters p = new CMAParameters();
        p.supplementRemainders(N, new CMAOptions());
        return p;
    }

    public CMAParameters getDefaults(int N, int lambda) {
        CMAParameters p = new CMAParameters();
        p.setLambda(lambda);
        p.supplementRemainders(N, new CMAOptions());
        return p;
    }

    public void supplementRemainders(int N, CMAOptions opts) {
        String s;
        if (this.supplemented > 0) {
            this.error("defaults cannot be supplemented twice");
        }
        if (N == 0) {
            this.error("dimension must be greater than zero");
        }
        this.supplemented = 1;
        this.locked = 1;
        this.chiN = Math.sqrt(N) * (1.0 - 1.0 / (4.0 * (double)N) + 1.0 / (21.0 * (double)N * (double)N));
        if (this.lambda <= 0) {
            this.lambda = (int)(4.0 + 3.0 * Math.log(N));
        }
        if (this.mu <= 0) {
            this.mu = (int)Math.floor((double)this.lambda / 2.0);
        }
        if (this.weights == null) {
            this.setWeights(this.mu, this.recombinationType);
        } else if (this.weights.length == 0) {
            this.setWeights(this.mu, this.recombinationType);
        }
        if (this.cs <= 0.0) {
            this.cs = (this.mueff + 2.0) / ((double)N + this.mueff + 3.0);
        }
        if (this.damps <= 0.0) {
            this.damps = (1.0 + 2.0 * Math.max(0.0, Math.sqrt((this.mueff - 1.0) / ((double)N + 1.0)) - 1.0)) * Math.max(0.3, 1.0 - (double)N / (1.0E-6 + (double)Math.min(opts.stopMaxIter, opts.stopMaxFunEvals / (long)this.lambda))) + this.cs;
        }
        if (this.cc <= 0.0) {
            this.cc = 4.0 / ((double)N + 4.0);
        }
        if (this.mucov < 0.0) {
            this.mucov = this.mueff;
        }
        if (this.ccov < 0.0) {
            this.ccov = 2.0 / ((double)N + 1.41) / ((double)N + 1.41) / this.mucov + (1.0 - 1.0 / this.mucov) * Math.min(1.0, (2.0 * this.mueff - 1.0) / (this.mueff + (double)((N + 2) * (N + 2))));
            this.ccovsep = Math.min(1.0, this.ccov * ((double)N + 1.5) / 3.0);
        }
        if ((s = this.check()) != null && !s.equals("")) {
            this.error(s);
        }
    }

    public int getMu() {
        return this.mu;
    }

    public void setMu(int mu) {
        if (this.locked != 0) {
            this.error("parameters are locked");
        }
        this.mu = mu;
    }

    public int getLambda() {
        return this.lambda;
    }

    void setLambda(int lambda) {
        if (this.locked != 0) {
            this.error("parameters cannot be set anymore");
        }
        this.lambda = lambda;
    }

    public int getPopulationSize() {
        return this.getLambda();
    }

    public void setPopulationSize(int lambda) {
        this.setLambda(lambda);
    }

    public double[] getWeights() {
        return this.weights;
    }

    public void setRecombinationWeights(RecombinationType recombinationType) {
        if (this.locked != 0) {
            this.error("parameters cannot be set anymore");
        }
        this.recombinationType = recombinationType;
    }

    public void setRecombination(int mu, RecombinationType recombinationType) {
        if (this.locked != 0) {
            this.error("parameters are locked");
        }
        this.mu = mu;
        this.recombinationType = recombinationType;
    }

    private void setWeights(int mu, RecombinationType recombinationType) {
        double[] w = new double[mu];
        if (recombinationType == RecombinationType.equal) {
            int i = 0;
            while (i < mu) {
                w[i] = 1.0;
                ++i;
            }
        } else if (recombinationType == RecombinationType.linear) {
            int i = 0;
            while (i < mu) {
                w[i] = mu - i;
                ++i;
            }
        } else {
            int i = 0;
            while (i < mu) {
                w[i] = Math.log(mu + 1) - Math.log(i + 1);
                ++i;
            }
        }
        this.setWeights(w);
    }

    protected void setWeights(double[] weights) {
        assert (this.locked == 0);
        double sum = 0.0;
        int i = 0;
        while (i < weights.length) {
            sum += weights[i];
            ++i;
        }
        i = 0;
        while (i < weights.length) {
            int n = i++;
            weights[n] = weights[n] / sum;
        }
        this.weights = weights;
        double sum1 = 0.0;
        double sum2 = 0.0;
        int i2 = 0;
        while (i2 < this.mu) {
            sum1 += weights[i2];
            sum2 += weights[i2] * weights[i2];
            ++i2;
        }
        this.mueff = sum1 * sum1 / sum2;
    }

    public double getMueff() {
        return this.mueff;
    }

    public double getMucov() {
        return this.mucov;
    }

    public void setMucov(double mucov) {
        if (this.locked != 0) {
            this.error("parameters cannot be set anymore");
        }
        this.mucov = mucov;
    }

    public double getCcov(boolean flgdiag) {
        if (flgdiag) {
            return this.ccovsep;
        }
        return this.ccov;
    }

    public double getCcov() {
        return this.ccov;
    }

    public void setCcov(double ccov) {
        this.ccov = ccov;
    }

    public double getDamps() {
        return this.damps;
    }

    public void setDamps(double damps) {
        if (this.locked != 0) {
            this.error("parameters cannot be set anymore");
        }
        this.damps = damps;
    }

    public double getCc() {
        return this.cc;
    }

    public void setCc(double cc) {
        this.cc = cc;
    }

    public double getCs() {
        return this.cs;
    }

    public void setCs(double cs) {
        if (this.locked != 0) {
            this.error("parameters cannot be set anymore");
        }
        this.cs = cs;
    }

    private void error(String s) {
        System.out.println(" CMA-ES error: " + s);
        CMAEvolutionStrategy cMAEvolutionStrategy = new CMAEvolutionStrategy();
        cMAEvolutionStrategy.getClass();
        throw new CMAEvolutionStrategy.CMAException(cMAEvolutionStrategy, " CMA-ES error: " + s);
    }

    public static enum RecombinationType {
        superlinear,
        linear,
        equal;

    }
}

