/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.optimization.cmaes.fitness;

import fr.inria.optimization.cmaes.fitness.AbstractObjectiveFunction;
import fr.inria.optimization.cmaes.fitness.Ackley;
import fr.inria.optimization.cmaes.fitness.Basis;
import fr.inria.optimization.cmaes.fitness.CigTab;
import fr.inria.optimization.cmaes.fitness.Cigar;
import fr.inria.optimization.cmaes.fitness.DiffPow;
import fr.inria.optimization.cmaes.fitness.Elli;
import fr.inria.optimization.cmaes.fitness.IObjectiveFunction;
import fr.inria.optimization.cmaes.fitness.RandFun;
import fr.inria.optimization.cmaes.fitness.Rastrigin;
import fr.inria.optimization.cmaes.fitness.Rosen;
import fr.inria.optimization.cmaes.fitness.Sphere;
import fr.inria.optimization.cmaes.fitness.Tablet;
import fr.inria.optimization.cmaes.fitness.TwoAxes;
import fr.inria.optimization.cmaes.fitness.ssDiffPow;

public class FunctionCollector
extends AbstractObjectiveFunction {
    final int maxFuncNumber = 999;
    IObjectiveFunction[] funs = new IObjectiveFunction[1000];
    int actFun = 0;
    int rotate = 0;
    double scaling = 1.0;
    Basis B = new Basis();

    public FunctionCollector(double function_number, int flgRotate, double axisratio) {
        this.actFun = (int)function_number;
        this.rotate = flgRotate;
        double d = this.scaling = axisratio == 0.0 ? 1.0 : axisratio;
        if (this.actFun > 999) {
            this.actFun = 1;
        }
        this.funs[0] = new RandFun();
        this.funs[10] = new Sphere();
        this.funs[30] = new Cigar(axisratio == 0.0 ? 1000.0 : this.scaling);
        this.funs[40] = new Tablet(axisratio == 0.0 ? 1000.0 : this.scaling);
        this.funs[50] = new Elli(axisratio == 0.0 ? 1000.0 : this.scaling);
        this.funs[60] = new CigTab(axisratio == 0.0 ? 10000.0 : this.scaling);
        this.funs[70] = new TwoAxes(axisratio == 0.0 ? 1000.0 : this.scaling);
        this.funs[80] = new Rosen();
        this.funs[90] = new DiffPow();
        this.funs[91] = new ssDiffPow();
        this.funs[150] = new Rastrigin(this.scaling, 10.0);
        this.funs[160] = new Ackley(this.scaling);
    }

    @Override
    public double valueOf(double[] x) {
        x = (double[])x.clone();
        if (this.rotate > 0) {
            x = this.B.Rotate(x);
        }
        if (this.scaling != 1.0) {
            int i = 0;
            while (i < x.length) {
                x[i] = Math.pow(10.0, (double)i / ((double)x.length - 1.0)) * x[i];
                ++i;
            }
        }
        return this.funs[this.actFun] == null ? this.funs[0].valueOf(x) : this.funs[this.actFun].valueOf(x);
    }

    @Override
    public boolean isFeasible(double[] x) {
        return this.funs[this.actFun].isFeasible(x);
    }
}

