/*
 * Decompiled with CFR 0.152.
 */
package internal.text.base.api;

import internal.text.base.api.XmlParam;
import java.util.List;
import java.util.function.Function;
import jdplus.text.base.api.XmlBean;
import jdplus.toolkit.base.api.timeseries.TsCollection;
import jdplus.toolkit.base.tsp.DataSet;
import jdplus.toolkit.base.tsp.DataSource;
import jdplus.toolkit.base.tsp.HasDataDisplayName;
import jdplus.toolkit.base.tsp.util.DataSourcePreconditions;
import lombok.Generated;
import lombok.NonNull;

public final class XmlDataDisplayName
implements HasDataDisplayName {
    private final String providerName;
    private final XmlParam param;
    private final Function<DataSource, List<TsCollection>> resources;

    @NonNull
    public String getDisplayName(@NonNull DataSource dataSource) throws IllegalArgumentException {
        if (dataSource == null) {
            throw new NullPointerException("dataSource is marked non-null but is null");
        }
        DataSourcePreconditions.checkProvider((String)this.providerName, (DataSource)dataSource);
        XmlBean bean = (XmlBean)this.param.get(dataSource);
        return bean.getFile().getPath();
    }

    @NonNull
    public String getDisplayName(@NonNull DataSet dataSet) throws IllegalArgumentException {
        if (dataSet == null) {
            throw new NullPointerException("dataSet is marked non-null but is null");
        }
        DataSourcePreconditions.checkProvider((String)this.providerName, (DataSet)dataSet);
        Integer collectionIndex = (Integer)this.param.getCollectionParam().get(dataSet);
        Integer seriesIndex = (Integer)this.param.getSeriesParam().get(dataSet);
        List<TsCollection> data = this.resources.apply(dataSet.getDataSource());
        if (data != null) {
            TsCollection col = data.get(collectionIndex);
            switch (dataSet.getKind()) {
                case COLLECTION: {
                    return col.getName();
                }
                case SERIES: {
                    return col.getName() + " - " + col.get(seriesIndex.intValue()).getName();
                }
            }
        } else {
            switch (dataSet.getKind()) {
                case COLLECTION: {
                    return String.valueOf(collectionIndex);
                }
                case SERIES: {
                    return collectionIndex + " - " + seriesIndex;
                }
            }
        }
        return "";
    }

    @NonNull
    public String getDisplayNodeName(@NonNull DataSet dataSet) {
        if (dataSet == null) {
            throw new NullPointerException("dataSet is marked non-null but is null");
        }
        DataSourcePreconditions.checkProvider((String)this.providerName, (DataSet)dataSet);
        Integer collectionIndex = (Integer)this.param.getCollectionParam().get(dataSet);
        Integer seriesIndex = (Integer)this.param.getSeriesParam().get(dataSet);
        List<TsCollection> data = this.resources.apply(dataSet.getDataSource());
        if (data != null) {
            TsCollection col = data.get(collectionIndex);
            switch (dataSet.getKind()) {
                case COLLECTION: {
                    return col.getName();
                }
                case SERIES: {
                    return col.get(seriesIndex.intValue()).getName();
                }
            }
        } else {
            switch (dataSet.getKind()) {
                case COLLECTION: {
                    return String.valueOf(collectionIndex);
                }
                case SERIES: {
                    return String.valueOf(seriesIndex);
                }
            }
        }
        return "";
    }

    @Generated
    private XmlDataDisplayName(String providerName, XmlParam param, Function<DataSource, List<TsCollection>> resources) {
        this.providerName = providerName;
        this.param = param;
        this.resources = resources;
    }

    @Generated
    public static @org.jspecify.annotations.NonNull XmlDataDisplayName of(String providerName, XmlParam param, Function<DataSource, List<TsCollection>> resources) {
        return new XmlDataDisplayName(providerName, param, resources);
    }
}

