/*
 * Decompiled with CFR 0.152.
 */
package standalone_spreadsheet.org.dhatim.fastexcel;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import standalone_spreadsheet.org.dhatim.fastexcel.Alignment;
import standalone_spreadsheet.org.dhatim.fastexcel.Border;
import standalone_spreadsheet.org.dhatim.fastexcel.DifferentialFormat;
import standalone_spreadsheet.org.dhatim.fastexcel.Fill;
import standalone_spreadsheet.org.dhatim.fastexcel.Font;
import standalone_spreadsheet.org.dhatim.fastexcel.Protection;
import standalone_spreadsheet.org.dhatim.fastexcel.Style;
import standalone_spreadsheet.org.dhatim.fastexcel.ThrowingConsumer;
import standalone_spreadsheet.org.dhatim.fastexcel.Writer;

final class StyleCache {
    private final ConcurrentMap<String, Integer> valueFormattings = new ConcurrentHashMap<String, Integer>();
    private final ConcurrentMap<Font, Integer> fonts = new ConcurrentHashMap<Font, Integer>();
    private final ConcurrentMap<Fill, Integer> fills = new ConcurrentHashMap<Fill, Integer>();
    private final ConcurrentMap<Border, Integer> borders = new ConcurrentHashMap<Border, Integer>();
    private final ConcurrentMap<Style, Integer> styles = new ConcurrentHashMap<Style, Integer>();
    private final ConcurrentMap<DifferentialFormat, Integer> dxfs = new ConcurrentHashMap<DifferentialFormat, Integer>();

    StyleCache() {
        this.mergeAndCacheStyle(0, null, Font.DEFAULT, Fill.NONE, Border.NONE, null, null);
        this.cacheFill(Fill.GRAY125);
    }

    private static <T> int cacheStuff(ConcurrentMap<T, Integer> cache, T t, Function<T, Integer> indexFunction) {
        return cache.computeIfAbsent(t, indexFunction);
    }

    private static <T> int cacheStuff(ConcurrentMap<T, Integer> cache, T t) {
        return StyleCache.cacheStuff(cache, t, k -> cache.size());
    }

    int cacheValueFormatting(String s) {
        if (s == null) {
            return 0;
        }
        return StyleCache.cacheStuff(this.valueFormattings, s, k -> this.valueFormattings.size() + 165);
    }

    int cacheFont(Font f) {
        return StyleCache.cacheStuff(this.fonts, f);
    }

    int cacheFill(Fill f) {
        return StyleCache.cacheStuff(this.fills, f);
    }

    int cacheBorder(Border b) {
        return StyleCache.cacheStuff(this.borders, b);
    }

    int cacheDxf(DifferentialFormat f) {
        return StyleCache.cacheStuff(this.dxfs, f);
    }

    int mergeAndCacheStyle(int currentStyle, String numberingFormat, Font font, Fill fill, Border border, Alignment alignment, Protection protection) {
        Style original = this.styles.entrySet().stream().filter(e -> ((Integer)e.getValue()).equals(currentStyle)).map(Map.Entry::getKey).findFirst().orElse(null);
        Style s = new Style(original, this.cacheValueFormatting(numberingFormat), this.cacheFont(font), this.cacheFill(fill), this.cacheBorder(border), alignment, protection);
        return StyleCache.cacheStuff(this.styles, s);
    }

    void replaceDefaultFont(Font font) {
        this.fonts.entrySet().removeIf(entry -> (Integer)entry.getValue() == 0);
        this.fonts.putIfAbsent(font, 0);
    }

    private static <T> void writeCache(Writer w, Map<T, Integer> cache, String name, ThrowingConsumer<Map.Entry<T, Integer>> consumer) throws IOException {
        w.append('<').append(name).append(" count=\"").append(cache.size()).append("\">");
        ArrayList<Map.Entry<T, Integer>> entries = new ArrayList<Map.Entry<T, Integer>>(cache.entrySet());
        entries.sort(Comparator.comparingInt(Map.Entry::getValue));
        for (Map.Entry entry : entries) {
            consumer.accept(entry);
        }
        w.append("</").append(name).append('>');
    }

    void write(Writer w) throws IOException {
        w.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?><styleSheet xmlns=\"http://schemas.openxmlformats.org/spreadsheetml/2006/main\">");
        StyleCache.writeCache(w, this.valueFormattings, "numFmts", e -> w.append("<numFmt numFmtId=\"").append((Integer)e.getValue()).append("\" formatCode=\"").append((String)e.getKey()).append("\"/>"));
        StyleCache.writeCache(w, this.fonts, "fonts", e -> ((Font)e.getKey()).write(w));
        StyleCache.writeCache(w, this.fills, "fills", e -> ((Fill)e.getKey()).write(w));
        StyleCache.writeCache(w, this.borders, "borders", e -> ((Border)e.getKey()).write(w));
        w.append("<cellStyleXfs count=\"1\"><xf numFmtId=\"0\" fontId=\"0\" fillId=\"0\" borderId=\"0\"/></cellStyleXfs>");
        StyleCache.writeCache(w, this.styles, "cellXfs", e -> ((Style)e.getKey()).write(w));
        StyleCache.writeCache(w, this.dxfs, "dxfs", e -> ((DifferentialFormat)e.getKey()).write(w));
        w.append("</styleSheet>");
    }
}

