/*
 * Decompiled with CFR 0.152.
 */
package internal.toolkit.base.core.arima;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.data.DoubleSeqCursor;
import jdplus.toolkit.base.core.arima.ArimaException;
import jdplus.toolkit.base.core.arima.IArimaModel;
import jdplus.toolkit.base.core.arima.estimation.ArmaFilter;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.stats.likelihood.DeterminantalTerm;

public class KalmanFilter
implements ArmaFilter {
    private double[] C0;
    private double[] C;
    private double[] s;
    private final boolean multiUse;
    private double[] phi;
    private int dim;
    private int n;
    private int steadyPos;
    private double ldet = Double.NaN;
    private double h0;
    private double var;
    private static final double EPS = 1.0E-15;

    public KalmanFilter() {
        this.multiUse = false;
    }

    public KalmanFilter(boolean multiuse) {
        this.multiUse = multiuse;
    }

    private void calcC() {
        double[] L = (double[])this.C0.clone();
        this.C = new double[this.dim * this.n];
        for (int i = 0; i < this.dim; ++i) {
            this.C[i] = L[i];
        }
        this.s = new double[this.n];
        double h = this.h0;
        DeterminantalTerm det = new DeterminantalTerm();
        int pos = 0;
        int ccur = 0;
        int cnext = this.dim;
        int ilast = this.dim - 1;
        this.steadyPos = this.n - 1;
        do {
            int k;
            if (Double.isNaN(h) || h < 0.0) {
                throw new ArimaException("invalid ARIMA");
            }
            det.add(h);
            this.s[pos] = Math.sqrt(h);
            if (pos >= this.steadyPos) continue;
            double zl = L[0];
            double zlv = zl / h;
            double llast = this.tlast(L);
            double clast = this.C[ccur + ilast];
            int i = 0;
            int j = ccur;
            int k2 = cnext;
            while (i < ilast) {
                double li = L[i + 1];
                if (zlv != 0.0) {
                    L[i] = li - this.C[j] * zlv;
                    this.C[k2] = this.C[j] - zlv * li;
                } else {
                    L[i] = li;
                    this.C[k2] = this.C[j];
                }
                ++i;
                ++j;
                ++k2;
            }
            L[ilast] = llast - zlv * clast;
            this.C[cnext + ilast] = this.C[ccur + ilast] - zlv * llast;
            if ((h -= zl * zlv) < this.var) {
                h = this.var;
            }
            for (k = 0; k < L.length && !(Math.abs(L[k]) > 1.0E-15); ++k) {
            }
            if (k == L.length) {
                this.steadyPos = pos + 1;
            }
            ccur = cnext;
            cnext += this.dim;
        } while (++pos < this.n);
        this.ldet = det.getLogDeterminant();
    }

    private void calcdet() {
        DeterminantalTerm det = new DeterminantalTerm();
        double[] C = (double[])this.C0.clone();
        double[] L = (double[])C.clone();
        double h = this.h0;
        int pos = 0;
        int ilast = this.dim - 1;
        this.steadyPos = this.n;
        do {
            if (Double.isNaN(h) || h < 0.0) {
                throw new ArimaException("invalid ARIMA");
            }
            det.add(h);
            if (pos < this.steadyPos) {
                int k;
                double zl = L[0];
                double zlv = zl / h;
                double llast = this.tlast(L);
                double clast = C[ilast];
                for (int i = 0; i < ilast; ++i) {
                    double li = L[i + 1];
                    if (zlv != 0.0) {
                        L[i] = li - C[i] * zlv;
                        int n = i;
                        C[n] = C[n] - zlv * li;
                        continue;
                    }
                    L[i] = li;
                }
                L[ilast] = llast - zlv * clast;
                int n = ilast;
                C[n] = C[n] - zlv * llast;
                if ((h -= zl * zlv) < this.var) {
                    h = this.var;
                }
                for (k = 0; k < L.length && !(Math.abs(L[k]) > 1.0E-15); ++k) {
                }
                if (k != L.length) continue;
                this.steadyPos = pos + 1;
                continue;
            }
            if (h == 1.0) break;
        } while (++pos < this.n);
        this.ldet = det.getLogDeterminant();
    }

    @Override
    public void apply(DoubleSeq y, DataBlock outrc) {
        if (this.multiUse) {
            this.mfilter(y, outrc);
        } else {
            this.sfilter(y, outrc);
        }
    }

    @Override
    public double getLogDeterminant() {
        if (Double.isNaN(this.ldet)) {
            this.calcdet();
        }
        return this.ldet;
    }

    @Override
    public int prepare(IArimaModel model, int length) {
        this.var = model.getInnovationVariance();
        this.ldet = Double.NaN;
        this.phi = model.getAr().asPolynomial().toArray();
        this.dim = Math.max(model.getArOrder(), model.getMaOrder() + 1);
        this.C0 = model.getAutoCovarianceFunction().values(this.dim);
        this.h0 = this.C0[0];
        this.n = length;
        this.tx(this.C0);
        if (this.multiUse) {
            this.calcC();
        }
        return length;
    }

    private void mfilter(DoubleSeq y, DataBlock yf) {
        double[] a = new double[this.dim];
        DoubleSeqCursor yreader = y.cursor();
        DoubleSeqCursor.OnMutable yfwriter = yf.cursor();
        int pos = 0;
        int cpos = 0;
        int ilast = this.dim - 1;
        boolean started = false;
        do {
            double z;
            if ((z = yreader.getAndNext()) != 0.0) {
                started = true;
            }
            double s = this.s[pos];
            double e = (z - a[0]) / s;
            yfwriter.setAndNext(e);
            if (started) {
                double la = this.tlast(a);
                if (e != 0.0) {
                    double v = e / s;
                    int i = 0;
                    int j = cpos;
                    while (i < ilast) {
                        a[i] = a[i + 1] + this.C[j] * v;
                        ++i;
                        ++j;
                    }
                    a[ilast] = la + this.C[cpos + ilast] * v;
                } else {
                    for (int i = 0; i < ilast; ++i) {
                        a[i] = a[i + 1];
                    }
                    a[ilast] = la;
                }
            }
            if (pos >= this.steadyPos) continue;
            cpos += this.dim;
        } while (++pos < this.n);
    }

    private void sfilter(DoubleSeq y, DataBlock outrc) {
        DeterminantalTerm det = new DeterminantalTerm();
        double[] C = (double[])this.C0.clone();
        double[] L = (double[])C.clone();
        double h = this.h0;
        double[] a = new double[this.dim];
        double[] yf = new double[this.n];
        int pos = 0;
        int ilast = this.dim - 1;
        this.steadyPos = this.n - 1;
        do {
            int k;
            if (Double.isNaN(h) || h < 0.0) {
                throw new ArimaException("invalid ARIMA");
            }
            det.add(h);
            double s = Math.sqrt(h);
            double e = y.get(pos) - a[0];
            yf[pos] = e / s;
            double la = this.tlast(a);
            if (e != 0.0) {
                double v = e / h;
                for (int i = 0; i < ilast; ++i) {
                    a[i] = a[i + 1] + C[i] * v;
                }
                a[ilast] = la + C[ilast] * v;
            } else {
                for (int i = 0; i < ilast; ++i) {
                    a[i] = a[i + 1];
                }
                a[ilast] = la;
            }
            if (pos >= this.steadyPos) continue;
            double zl = L[0];
            double zlv = zl / h;
            double llast = this.tlast(L);
            double clast = C[ilast];
            for (int i = 0; i < ilast; ++i) {
                double li = L[i + 1];
                if (zlv != 0.0) {
                    L[i] = li - C[i] * zlv;
                    int n = i;
                    C[n] = C[n] - zlv * li;
                    continue;
                }
                L[i] = li;
            }
            L[ilast] = llast - zlv * clast;
            int n = ilast;
            C[n] = C[n] - zlv * llast;
            if ((h -= zl * zlv) < this.var) {
                h = this.var;
            }
            for (k = 0; k < L.length && !(Math.abs(L[k]) > 1.0E-15); ++k) {
            }
            if (k != L.length) continue;
            this.steadyPos = pos + 1;
        } while (++pos < this.n);
        this.ldet = det.getLogDeterminant();
        outrc.copy(DataBlock.of(yf));
    }

    private double tlast(double[] x) {
        double last = 0.0;
        for (int i = 1; i < this.phi.length; ++i) {
            last -= this.phi[i] * x[this.dim - i];
        }
        return last;
    }

    private void tx(double[] x) {
        int i;
        double last = 0.0;
        for (i = 1; i < this.phi.length; ++i) {
            last -= this.phi[i] * x[this.dim - i];
        }
        for (i = 1; i < this.dim; ++i) {
            x[i - 1] = x[i];
        }
        x[this.dim - 1] = last;
    }
}

