/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.alignment;

import dr.evolution.alignment.Alignment;
import dr.evolution.alignment.SiteList;
import dr.evolution.alignment.SitePatterns;
import dr.evolution.util.TaxonList;
import dr.util.Citable;
import dr.util.Citation;
import dr.util.CommonCitations;
import java.util.Collections;
import java.util.List;

public class AscertainedSitePatterns
extends SitePatterns
implements Citable {
    protected int[] includePatterns;
    protected int[] excludePatterns;
    protected int ascertainmentIncludeCount;
    protected int ascertainmentExcludeCount;

    public AscertainedSitePatterns(Alignment alignment) {
        super(alignment);
    }

    public AscertainedSitePatterns(Alignment alignment, TaxonList taxonList) {
        super(alignment, taxonList);
    }

    public AscertainedSitePatterns(Alignment alignment, int n, int n2, int n3) {
        super(alignment, n, n2, n3);
    }

    public AscertainedSitePatterns(Alignment alignment, TaxonList taxonList, int n, int n2, int n3) {
        super(alignment, taxonList, n, n2, n3);
    }

    public AscertainedSitePatterns(SiteList siteList) {
        super(siteList);
    }

    public AscertainedSitePatterns(SiteList siteList, int n, int n2, int n3) {
        super(siteList, n, n2, n3);
    }

    public AscertainedSitePatterns(Alignment alignment, TaxonList taxonList, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        super(alignment, taxonList, n, n2, n3);
        int[][] nArrayArray = new int[this.patterns.length + (n5 - n4) + (n7 - n6)][];
        double[] dArray = new double[this.patterns.length + (n5 - n4) + (n7 - n6)];
        for (int i = 0; i < this.patterns.length; ++i) {
            nArrayArray[i] = this.patterns[i];
            dArray[i] = this.weights[i];
        }
        this.patterns = nArrayArray;
        this.weights = dArray;
        if (n5 - n4 >= 1) {
            this.includePatterns(n4, n5, n3);
        }
        if (n7 - n6 >= 1) {
            this.excludePatterns(n6, n7, n3);
        }
    }

    @Override
    public Citation.Category getCategory() {
        return Citation.Category.DATA_MODELS;
    }

    @Override
    public String getDescription() {
        return "Ascertained Site Patterns";
    }

    @Override
    public List<Citation> getCitations() {
        return Collections.singletonList(CommonCitations.ALEKSEYENKO_2008);
    }

    public int getIncludePatternCount() {
        return this.ascertainmentIncludeCount;
    }

    public int[] getIncludePatternIndices() {
        return this.includePatterns;
    }

    protected void includePatterns(int n, int n2, int n3) {
        if (this.includePatterns == null) {
            this.includePatterns = new int[n2 - n];
        }
        for (int i = n; i < n2; i += n3) {
            int n4;
            int[] nArray = this.siteList.getPattern(i);
            this.includePatterns[this.ascertainmentIncludeCount] = n4 = this.addAscertainmentPattern(nArray);
            ++this.ascertainmentIncludeCount;
        }
    }

    public int getExcludePatternCount() {
        return this.ascertainmentExcludeCount;
    }

    public int[] getExcludePatternIndices() {
        return this.excludePatterns;
    }

    protected void excludePatterns(int n, int n2, int n3) {
        if (this.excludePatterns == null) {
            this.excludePatterns = new int[n2 - n];
        }
        for (int i = n; i < n2; i += n3) {
            int[] nArray = this.siteList.getPattern(i);
            int n4 = this.addAscertainmentPattern(nArray);
            this.weights[n4] = 0.0;
            this.excludePatterns[this.ascertainmentExcludeCount] = n4;
            ++this.ascertainmentExcludeCount;
        }
    }

    public double getAscertainmentCorrection(double[] dArray) {
        int n;
        int n2;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 1.0;
        int[] nArray = this.getIncludePatternIndices();
        int[] nArray2 = this.getExcludePatternIndices();
        for (n2 = 0; n2 < this.getIncludePatternCount(); ++n2) {
            n = nArray[n2];
            d2 += Math.exp(dArray[n]);
        }
        for (n2 = 0; n2 < this.getExcludePatternCount(); ++n2) {
            n = nArray2[n2];
            d += Math.exp(dArray[n]);
        }
        d3 = d2 == 0.0 ? (d3 -= d) : (d == 0.0 ? d2 : d2 - d);
        return Math.log(d3);
    }

    private int addAscertainmentPattern(int[] nArray) {
        int n;
        for (n = 0; n < this.patternCount; ++n) {
            if (!this.comparePatterns(this.patterns[n], nArray)) continue;
            return n;
        }
        n = this.patternCount++;
        this.patterns[n] = nArray;
        this.weights[n] = 0.0;
        return n;
    }
}

