/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.substmodel;

import dr.evolution.datatype.Codons;
import dr.evolution.datatype.DataType;
import dr.evolution.datatype.Nucleotides;
import dr.evomodel.substmodel.FrequencyModel;
import dr.inference.loggers.LogColumn;
import dr.inference.loggers.Loggable;
import dr.inference.loggers.NumberColumn;
import dr.inference.model.Model;
import dr.inference.model.Parameter;

public class CodonFromNucleotideFrequencyModel
extends FrequencyModel
implements Loggable {
    private final FrequencyModel nucleotideFrequencyModel;
    private final Codons dataType;
    private final Parameter codonFrequencies;

    public CodonFromNucleotideFrequencyModel(Codons codons, FrequencyModel frequencyModel, Parameter parameter) {
        super((DataType)codons, parameter);
        if (frequencyModel.getDataType() != Nucleotides.INSTANCE) {
            throw new IllegalArgumentException("Must provide a nucleotide frequency model");
        }
        this.codonFrequencies = parameter;
        this.dataType = codons;
        this.nucleotideFrequencyModel = frequencyModel;
        this.updateFrequencyParameter();
        this.addModel(frequencyModel);
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
        assert (model == this.nucleotideFrequencyModel);
        this.updateFrequencyParameter();
        this.fireModelChanged(model);
    }

    private void updateFrequencyParameter() {
        for (int i = 0; i < 4; ++i) {
            double d = this.nucleotideFrequencyModel.getFrequency(i);
            for (int j = 0; j < 4; ++j) {
                double d2 = this.nucleotideFrequencyModel.getFrequency(j);
                for (int k = 0; k < 4; ++k) {
                    double d3 = this.nucleotideFrequencyModel.getFrequency(k);
                    int n = this.dataType.getState(i, j, k);
                    if (this.dataType.isStopCodon(n)) continue;
                    this.frequencyParameter.setParameterValue(n, d * d2 * d3);
                }
            }
        }
        double d = this.getSumOfFrequencies(this.frequencyParameter);
        for (int i = 0; i < this.frequencyParameter.getSize(); ++i) {
            this.frequencyParameter.setParameterValue(i, this.frequencyParameter.getParameterValue(i) / d);
        }
    }

    private String getDimensionName(int n) {
        return this.codonFrequencies.getParameterName() + "." + this.dataType.getTriplet(n);
    }

    @Override
    public LogColumn[] getColumns() {
        int n = this.codonFrequencies.getDimension();
        LogColumn[] logColumnArray = new LogColumn[n];
        for (int i = 0; i < n; ++i) {
            logColumnArray[i] = new CodonFrequencyColumn(this.getDimensionName(i), i);
        }
        return logColumnArray;
    }

    private class CodonFrequencyColumn
    extends NumberColumn {
        private final int dim;

        CodonFrequencyColumn(String string, int n) {
            super(string);
            this.dim = n;
        }

        @Override
        public double getDoubleValue() {
            return CodonFromNucleotideFrequencyModel.this.codonFrequencies.getParameterValue(this.dim);
        }
    }
}

