/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.treedatalikelihood.discrete;

import dr.evolution.tree.Tree;
import dr.evolution.tree.TreeTrait;
import dr.evomodel.branchmodel.BranchModel;
import dr.evomodel.substmodel.ComplexSubstitutionModel;
import dr.evomodel.substmodel.DifferentiableSubstitutionModelUtil;
import dr.evomodel.substmodel.EigenDecomposition;
import dr.evomodel.substmodel.LogRateSubstitutionModel;
import dr.evomodel.substmodel.SubstitutionModel;
import dr.evomodel.treedatalikelihood.BeagleDataLikelihoodDelegate;
import dr.evomodel.treedatalikelihood.ProcessSimulation;
import dr.evomodel.treedatalikelihood.TreeDataLikelihood;
import dr.evomodel.treedatalikelihood.discrete.SubstitutionModelCrossProductDelegate;
import dr.inference.hmc.GradientWrtParameterProvider;
import dr.inference.loggers.Loggable;
import dr.inference.model.Likelihood;
import dr.inference.model.Model;
import dr.inference.model.ModelListener;
import dr.util.Citable;
import dr.util.Transform;
import dr.xml.Reportable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public abstract class AbstractLogAdditiveSubstitutionModelGradient
implements GradientWrtParameterProvider,
ModelListener,
Reportable,
Loggable,
Citable {
    protected final TreeDataLikelihood treeDataLikelihood;
    protected final TreeTrait treeTraitProvider;
    protected final Tree tree;
    protected final BranchModel branchModel;
    protected final ComplexSubstitutionModel substitutionModel;
    protected final int stateCount;
    protected final List<Integer> crossProductAccumulationMap;
    protected final boolean scaleRatesByFrequencies;
    private final ApproximationMode mode;
    private final CorrectionTermCache correctionTermCache;
    protected static final boolean COUNT_TOTAL_OPERATIONS = false;
    protected long gradientCount = 0L;
    protected long totalGradientTime = 0L;

    public AbstractLogAdditiveSubstitutionModelGradient(String string, TreeDataLikelihood treeDataLikelihood, BeagleDataLikelihoodDelegate beagleDataLikelihoodDelegate, ComplexSubstitutionModel complexSubstitutionModel, ApproximationMode approximationMode) {
        this.treeDataLikelihood = treeDataLikelihood;
        this.tree = treeDataLikelihood.getTree();
        this.branchModel = beagleDataLikelihoodDelegate.getBranchModel();
        this.substitutionModel = complexSubstitutionModel;
        this.scaleRatesByFrequencies = complexSubstitutionModel.getScaleRatesByFrequencies();
        this.stateCount = complexSubstitutionModel.getDataType().getStateCount();
        this.crossProductAccumulationMap = this.createCrossProductAccumulationMap(beagleDataLikelihoodDelegate.getBranchModel(), complexSubstitutionModel);
        this.mode = approximationMode;
        this.correctionTermCache = approximationMode.createCache(complexSubstitutionModel, this.crossProductAccumulationMap);
        String string2 = SubstitutionModelCrossProductDelegate.getName(string);
        if (treeDataLikelihood.getTreeTrait(string2) == null) {
            SubstitutionModelCrossProductDelegate substitutionModelCrossProductDelegate = new SubstitutionModelCrossProductDelegate(string, treeDataLikelihood.getTree(), beagleDataLikelihoodDelegate, treeDataLikelihood.getBranchRateModel(), complexSubstitutionModel.getDataType().getStateCount());
            ProcessSimulation processSimulation = new ProcessSimulation(treeDataLikelihood, substitutionModelCrossProductDelegate);
            treeDataLikelihood.addTraits(processSimulation.getTreeTraits());
        }
        this.treeTraitProvider = treeDataLikelihood.getTreeTrait(string2);
        assert (this.treeTraitProvider != null);
        this.branchModel.addModelListener(this);
        this.substitutionModel.addModelListener(this);
        Logger.getLogger("dr.evomodel.treedatalikelihood.discrete").info("Gradient wrt " + string + " using " + approximationMode.getInfo() + " approximation");
    }

    protected abstract double preProcessNormalization(double[] var1, double[] var2, boolean var3);

    abstract double processSingleGradientDimension(int var1, double[] var2, double[] var3, double[] var4, boolean var5, double var6, double var8, Transform var10, boolean var11);

    @Override
    public double[] getGradientLogDensity() {
        double[] dArray = (double[])this.treeTraitProvider.getTrait(this.tree, null);
        double[] dArray2 = new double[dArray.length];
        this.accumulateAcrossSubstitutionModelInstances(dArray);
        this.substitutionModel.getInfinitesimalMatrix(dArray2);
        double[] dArray3 = this.substitutionModel.getFrequencyModel().getFrequencies();
        boolean bl = this.substitutionModel.getNormalization();
        double d = bl ? 1.0 / this.substitutionModel.setupMatrix() : 0.0;
        double d2 = this.preProcessNormalization(dArray, dArray2, this.substitutionModel.getNormalization());
        Transform transform = this.substitutionModel instanceof LogRateSubstitutionModel ? ((LogRateSubstitutionModel)this.substitutionModel).getTransform() : null;
        double[] dArray4 = new double[this.getParameter().getDimension()];
        for (int i = 0; i < this.getParameter().getDimension(); ++i) {
            dArray4[i] = this.processSingleGradientDimension(i, dArray, dArray2, dArray3, bl, d2, d, transform, this.scaleRatesByFrequencies);
        }
        return dArray4;
    }

    double correction(int n, int n2, double[] dArray) {
        return this.mode.computeCorrection(n, n2, dArray, this.stateCount, this.correctionTermCache);
    }

    private void accumulateAcrossSubstitutionModelInstances(double[] dArray) {
        int n = this.stateCount * this.stateCount;
        int n2 = this.crossProductAccumulationMap.get(0);
        if (n2 > 0) {
            System.arraycopy(dArray, n2 * n, dArray, 0, n);
        }
        for (int i = 1; i < this.crossProductAccumulationMap.size(); ++i) {
            int n3 = this.crossProductAccumulationMap.get(i);
            for (int j = 0; j < n; ++j) {
                int n4 = j;
                dArray[n4] = dArray[n4] + dArray[n3 * n + j];
            }
        }
    }

    private List<Integer> createCrossProductAccumulationMap(BranchModel branchModel, ComplexSubstitutionModel complexSubstitutionModel) {
        List<SubstitutionModel> list = branchModel.getSubstitutionModels();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < list.size(); ++i) {
            if (complexSubstitutionModel != list.get(i)) continue;
            arrayList.add(i);
        }
        return arrayList;
    }

    @Override
    public Likelihood getLikelihood() {
        return this.treeDataLikelihood;
    }

    @Override
    public int getDimension() {
        return this.getParameter().getDimension();
    }

    @Override
    public String getReport() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = GradientWrtParameterProvider.getReportAndCheckForError(this, 0.0, Double.POSITIVE_INFINITY, this.getReportTolerance());
        stringBuilder.append(string);
        return stringBuilder.toString();
    }

    Double getReportTolerance() {
        return null;
    }

    protected void handleModelChangedEvent(Model model, Object object, int n) {
        if (model == this.branchModel) {
            throw new RuntimeException("Not yet implemented");
        }
        if (model != this.substitutionModel) {
            throw new RuntimeException("Unknown model");
        }
        this.mode.emptyCache(this.correctionTermCache);
    }

    @Override
    public void modelChangedEvent(Model model, Object object, int n) {
    }

    @Override
    public void modelRestored(Model model) {
    }

    public static enum ApproximationMode {
        FIRST_ORDER("firstOrder"){

            @Override
            public String getInfo() {
                return "a first-order";
            }

            @Override
            CorrectionTermCache createCache(SubstitutionModel substitutionModel, List<Integer> list) {
                return null;
            }

            @Override
            void emptyCache(CorrectionTermCache correctionTermCache) {
            }

            @Override
            double computeCorrection(int n, int n2, double[] dArray, int n3, CorrectionTermCache correctionTermCache) {
                return 0.0;
            }
        }
        ,
        AFFINE_CORRECTED("affineCorrected"){

            @Override
            public String getInfo() {
                return "an affine-corrected";
            }

            @Override
            CorrectionTermCache createCache(SubstitutionModel substitutionModel, List<Integer> list) {
                if (list.size() > 1) {
                    throw new RuntimeException("Not yet implemented");
                }
                return new CorrectionTermCache(substitutionModel);
            }

            @Override
            void emptyCache(CorrectionTermCache correctionTermCache) {
                correctionTermCache.clear();
            }

            @Override
            double computeCorrection(int n, int n2, double[] dArray, int n3, CorrectionTermCache correctionTermCache) {
                double[] dArray2 = correctionTermCache.getAffineMatrix(n, n2);
                double d = 0.0;
                for (int i = 0; i < n3; ++i) {
                    for (int j = 0; j < n3; ++j) {
                        d += dArray[i * n3 + j] * dArray2[i * n3 + j];
                    }
                }
                return d;
            }
        };

        private final String label;

        private ApproximationMode(String string2) {
            this.label = string2;
        }

        abstract String getInfo();

        abstract CorrectionTermCache createCache(SubstitutionModel var1, List<Integer> var2);

        abstract void emptyCache(CorrectionTermCache var1);

        abstract double computeCorrection(int var1, int var2, double[] var3, int var4, CorrectionTermCache var5);

        public String getLabel() {
            return this.label;
        }

        public static ApproximationMode factory(String string) {
            for (ApproximationMode approximationMode : ApproximationMode.values()) {
                if (!approximationMode.getLabel().equalsIgnoreCase(string)) continue;
                return approximationMode;
            }
            throw new IllegalArgumentException("Unknown approximation mode");
        }
    }

    static class CorrectionTermCache {
        private final SubstitutionModel model;
        private final Map<Integer, double[]> map;
        private final int stateCount;
        private double[] qQPlus;

        CorrectionTermCache(SubstitutionModel substitutionModel) {
            this.model = substitutionModel;
            this.map = new HashMap<Integer, double[]>();
            this.stateCount = substitutionModel.getDataType().getStateCount();
            this.qQPlus = null;
        }

        private int index12(int n, int n2) {
            return n * this.stateCount + n2;
        }

        private double[] getQQPlus() {
            if (this.qQPlus == null) {
                EigenDecomposition eigenDecomposition = this.model.getEigenDecomposition();
                this.qQPlus = DifferentiableSubstitutionModelUtil.getQQPlus(eigenDecomposition.getEigenVectors(), eigenDecomposition.getInverseEigenVectors(), eigenDecomposition.getEigenValues(), this.stateCount);
            }
            return this.qQPlus;
        }

        double[] getAffineMatrix(int n, int n2) {
            double[] dArray = this.map.get(n * this.stateCount + n2);
            if (dArray == null) {
                dArray = new double[this.stateCount * this.stateCount];
                double[] dArray2 = this.getQQPlus();
                for (int i = 0; i < this.stateCount; ++i) {
                    for (int j = 0; j < this.stateCount; ++j) {
                        dArray[this.index12((int)i, (int)j)] = i == n ? (dArray2[this.index12(i, n)] - 1.0) * dArray2[this.index12(n2, j)] : dArray2[this.index12(i, n)] * dArray2[this.index12(n2, j)];
                    }
                }
                this.map.put(n * this.stateCount + n2, dArray);
            }
            return dArray;
        }

        public void clear() {
            this.map.clear();
            this.qQPlus = null;
        }
    }
}

