/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.hmc;

import dr.inference.hmc.GradientWrtParameterProvider;
import dr.inference.model.HessianProvider;
import dr.inference.model.Likelihood;
import dr.inference.model.Parameter;
import dr.inference.operators.hmc.NumericalHessianFromGradient;

public interface HessianWrtParameterProvider
extends GradientWrtParameterProvider {
    public double[] getDiagonalHessianLogDensity();

    public double[][] getHessianLogDensity();

    public static String getReportAndCheckForError(HessianWrtParameterProvider hessianWrtParameterProvider, Double d) {
        String string;
        try {
            string = new CheckHessianNumerically(hessianWrtParameterProvider, d).getReport();
        }
        catch (GradientWrtParameterProvider.MismatchException mismatchException) {
            String string2 = mismatchException.getMessage();
            if (string2 == null) {
                string2 = hessianWrtParameterProvider.getParameter().getParameterName();
            }
            if (string2 == null) {
                string2 = "Hessian check failure";
            }
            throw new RuntimeException(string2);
        }
        return string;
    }

    public static class CheckHessianNumerically {
        private final HessianWrtParameterProvider provider;
        private final NumericalHessianFromGradient numericProvider;
        private final boolean checkValues;
        private final double tolerance;
        private final double smallThreshold;

        CheckHessianNumerically(HessianWrtParameterProvider hessianWrtParameterProvider, Double d, Double d2) {
            this.provider = hessianWrtParameterProvider;
            this.numericProvider = new NumericalHessianFromGradient(hessianWrtParameterProvider);
            this.checkValues = d != null;
            this.tolerance = this.checkValues ? d : 0.0;
            this.smallThreshold = d2 != null ? d2 : 0.0;
        }

        CheckHessianNumerically(HessianWrtParameterProvider hessianWrtParameterProvider, Double d) {
            this(hessianWrtParameterProvider, d, null);
        }

        public String getReport() throws GradientWrtParameterProvider.MismatchException {
            double[] dArray = this.provider.getDiagonalHessianLogDensity();
            double[] dArray2 = this.numericProvider.getDiagonalHessianLogDensity();
            return GradientWrtParameterProvider.makeReport("Hessian\n", dArray, dArray2, this.checkValues, this.tolerance, this.smallThreshold);
        }
    }

    public static class ParameterWrapper
    implements HessianWrtParameterProvider {
        final HessianProvider provider;
        final Parameter parameter;
        final Likelihood likelihood;

        public ParameterWrapper(HessianProvider hessianProvider, Parameter parameter, Likelihood likelihood) {
            this.provider = hessianProvider;
            this.parameter = parameter;
            this.likelihood = likelihood;
        }

        @Override
        public Likelihood getLikelihood() {
            return this.likelihood;
        }

        @Override
        public Parameter getParameter() {
            return this.parameter;
        }

        @Override
        public int getDimension() {
            return this.parameter.getDimension();
        }

        @Override
        public double[] getGradientLogDensity() {
            return this.provider.getGradientLogDensity(this.parameter.getParameterValues());
        }

        @Override
        public double[] getDiagonalHessianLogDensity() {
            return this.provider.getDiagonalHessianLogDensity(this.parameter.getParameterValues());
        }

        @Override
        public double[][] getHessianLogDensity() {
            return this.provider.getHessianLogDensity(this.parameter.getParameterValues());
        }
    }
}

