/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.model;

import dr.inference.loggers.LogColumn;
import dr.inference.loggers.NumberColumn;
import dr.inference.model.CompoundModel;
import dr.inference.model.Likelihood;
import dr.inference.model.Model;
import dr.inference.model.Profileable;
import dr.util.Keywordable;
import dr.util.NumberFormatter;
import dr.xml.Reportable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class CompoundLikelihood
implements Likelihood,
Profileable,
Reportable,
Keywordable {
    public static final boolean UNROLL_COMPOUND = true;
    public static final boolean EVALUATION_TIMERS = true;
    public final long[] evaluationTimes;
    public final int[] evaluationCounts;
    private String id = null;
    private boolean used = false;
    private final int threadCount;
    private final ExecutorService pool;
    private final ArrayList<Likelihood> likelihoods = new ArrayList();
    private final CompoundModel compoundModel = new CompoundModel("compoundModel");
    private final ArrayList<Likelihood> earlyLikelihoods = new ArrayList();
    private final ArrayList<Likelihood> lateLikelihoods = new ArrayList();
    private final List<Callable<Double>> likelihoodCallers = new ArrayList<Callable<Double>>();
    public static final boolean DEBUG_PARALLEL_EVALUATION = false;

    public CompoundLikelihood(int n, Collection<Likelihood> collection) {
        int n2 = 0;
        for (Likelihood likelihood : collection) {
            this.addLikelihood(likelihood, n2, true);
            ++n2;
        }
        this.threadCount = n < 0 && this.likelihoods.size() > 1 ? this.likelihoods.size() : (n > 0 ? n : 0);
        this.pool = this.threadCount > 0 ? Executors.newFixedThreadPool(this.threadCount) : (this.threadCount < 0 ? Executors.newCachedThreadPool() : null);
        this.evaluationTimes = new long[this.likelihoods.size()];
        this.evaluationCounts = new int[this.likelihoods.size()];
    }

    public CompoundLikelihood(Collection<Likelihood> collection) {
        this.pool = null;
        this.threadCount = 0;
        int n = 0;
        for (Likelihood likelihood : collection) {
            this.addLikelihood(likelihood, n, false);
            ++n;
        }
        this.evaluationTimes = new long[this.likelihoods.size()];
        this.evaluationCounts = new int[this.likelihoods.size()];
    }

    protected void addLikelihood(Likelihood likelihood, int n, boolean bl) {
        if (bl && likelihood instanceof CompoundLikelihood) {
            for (Likelihood likelihood2 : ((CompoundLikelihood)likelihood).getLikelihoods()) {
                this.addLikelihood(likelihood2, n, bl);
            }
        } else if (!this.likelihoods.contains(likelihood)) {
            this.likelihoods.add(likelihood);
            if (likelihood.getModel() != null) {
                this.compoundModel.addModel(likelihood.getModel());
            }
            if (likelihood.evaluateEarly()) {
                this.earlyLikelihoods.add(likelihood);
            } else {
                this.lateLikelihoods.add(likelihood);
                if (bl) {
                    this.likelihoodCallers.add(new LikelihoodCaller(likelihood, n));
                }
            }
        } else {
            throw new IllegalArgumentException("Attempted to add the same likelihood multiple times to CompoundLikelihood.");
        }
    }

    @Override
    public Set<Likelihood> getLikelihoodSet() {
        HashSet<Likelihood> hashSet = new HashSet<Likelihood>();
        for (Likelihood likelihood : this.likelihoods) {
            hashSet.add(likelihood);
            hashSet.addAll(likelihood.getLikelihoodSet());
        }
        return hashSet;
    }

    public int getLikelihoodCount() {
        return this.likelihoods.size();
    }

    public final Likelihood getLikelihood(int n) {
        return this.likelihoods.get(n);
    }

    public List<Likelihood> getLikelihoods() {
        return this.likelihoods;
    }

    public List<Callable<Double>> getLikelihoodCallers() {
        return this.likelihoodCallers;
    }

    @Override
    public Model getModel() {
        return this.compoundModel;
    }

    @Override
    public double getLogLikelihood() {
        double d = this.evaluateLikelihoods(this.earlyLikelihoods);
        if (d == Double.NEGATIVE_INFINITY) {
            return Double.NEGATIVE_INFINITY;
        }
        if (this.pool == null) {
            d += this.evaluateLikelihoods(this.lateLikelihoods);
        } else {
            try {
                List<Future<Double>> list = this.pool.invokeAll(this.likelihoodCallers);
                for (Future<Double> future : list) {
                    double d2 = future.get();
                    d += d2;
                }
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
        }
        return d;
    }

    private double evaluateLikelihoods(ArrayList<Likelihood> arrayList) {
        double d = 0.0;
        int n = 0;
        for (Likelihood likelihood : arrayList) {
            long l = System.nanoTime();
            double d2 = likelihood.getLogLikelihood();
            int n2 = n;
            this.evaluationTimes[n2] = this.evaluationTimes[n2] + (System.nanoTime() - l);
            int n3 = n++;
            this.evaluationCounts[n3] = this.evaluationCounts[n3] + 1;
            if (d2 == Double.NEGATIVE_INFINITY) {
                return Double.NEGATIVE_INFINITY;
            }
            d += d2;
        }
        return d;
    }

    @Override
    public void makeDirty() {
        for (Likelihood likelihood : this.likelihoods) {
            likelihood.makeDirty();
        }
    }

    @Override
    public boolean evaluateEarly() {
        return false;
    }

    public String getDiagnosis() {
        return this.getDiagnosis(0);
    }

    public String getDiagnosis(int n) {
        String string = "";
        boolean bl = true;
        NumberFormatter numberFormatter = new NumberFormatter(6);
        for (Likelihood likelihood : this.likelihoods) {
            if (!bl) {
                string = string + ", ";
            } else {
                bl = false;
            }
            if (n >= 0) {
                string = string + "\n";
                for (int i = 0; i < n; ++i) {
                    string = string + " ";
                }
            }
            string = string + likelihood.prettyName() + "=";
            if (likelihood instanceof CompoundLikelihood) {
                String string2 = ((CompoundLikelihood)likelihood).getDiagnosis(n < 0 ? -1 : n + 2);
                if (string2 == null || string2.length() <= 0) continue;
                string = string + "(" + string2;
                if (n >= 0) {
                    string = string + "\n";
                    for (int i = 0; i < n; ++i) {
                        string = string + " ";
                    }
                }
                string = string + ")";
                continue;
            }
            double d = likelihood.getLogLikelihood();
            if (d == Double.NEGATIVE_INFINITY) {
                string = string + "-Inf";
                continue;
            }
            if (Double.isNaN(d)) {
                string = string + "NaN";
                continue;
            }
            if (d == Double.POSITIVE_INFINITY) {
                string = string + "+Inf";
                continue;
            }
            string = string + numberFormatter.formatDecimal(d, 4);
        }
        string = string + "\n";
        for (int i = 0; i < n; ++i) {
            string = string + " ";
        }
        string = string + "Total = " + this.getLogLikelihood();
        return string;
    }

    public String toString() {
        return this.getId();
    }

    @Override
    public String prettyName() {
        return Likelihood.Abstract.getPrettyName(this);
    }

    @Override
    public boolean isUsed() {
        return this.used;
    }

    @Override
    public void setUsed() {
        this.used = true;
        for (Likelihood likelihood : this.likelihoods) {
            likelihood.setUsed();
        }
    }

    public int getThreadCount() {
        return this.threadCount;
    }

    public long[] getEvaluationTimes() {
        return this.evaluationTimes;
    }

    public int[] getEvaluationCounts() {
        return this.evaluationCounts;
    }

    public void resetEvaluationTimes() {
        for (int i = 0; i < this.evaluationTimes.length; ++i) {
            this.evaluationTimes[i] = 0L;
            this.evaluationCounts[i] = 0;
        }
    }

    @Override
    public LogColumn[] getColumns() {
        return new LogColumn[]{new LikelihoodColumn(this.getId() == null ? "likelihood" : this.getId())};
    }

    @Override
    public void addKeyword(String string) {
        throw new UnsupportedOperationException("Can't add keywords here");
    }

    @Override
    public List<String> getKeywords() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Likelihood likelihood : this.likelihoods) {
            if (!(likelihood instanceof Keywordable)) continue;
            arrayList.addAll(((Keywordable)((Object)likelihood)).getKeywords());
        }
        return arrayList;
    }

    @Override
    public long getTotalCalculationCount() {
        long l = 0L;
        for (Likelihood likelihood : this.likelihoods) {
            if (!(likelihood instanceof Profileable)) continue;
            l += ((Profileable)((Object)likelihood)).getTotalCalculationCount();
        }
        return l;
    }

    @Override
    public String getReport() {
        return this.getReport(0);
    }

    public String getReport(int n) {
        String string = "\n";
        boolean bl = true;
        NumberFormatter numberFormatter = new NumberFormatter(6);
        double d = this.getLogLikelihood();
        int n2 = 0;
        for (Likelihood likelihood : this.likelihoods) {
            if (!bl) {
                string = string + ", ";
            } else {
                bl = false;
            }
            if (n >= 0) {
                string = string + "\n";
                for (int i = 0; i < n; ++i) {
                    string = string + " ";
                }
            }
            string = string + likelihood.prettyName() + "=";
            if (likelihood instanceof CompoundLikelihood) {
                String string2 = ((CompoundLikelihood)likelihood).getReport(n < 0 ? -1 : n + 2);
                if (string2 != null && string2.length() > 0) {
                    string = string + "(" + string2;
                    if (n >= 0) {
                        string = string + "\n";
                        for (int i = 0; i < n; ++i) {
                            string = string + " ";
                        }
                    }
                    string = string + ")";
                }
            } else {
                double d2 = (double)this.evaluationTimes[n2] / 1.0E9;
                string = string + this.evaluationCounts[n2] + " evaluations in " + numberFormatter.format(d2) + " secs (" + numberFormatter.format(d2 / (double)this.evaluationCounts[n2]) + " secs/eval)";
            }
            ++n2;
        }
        string = string + "\n\n";
        for (int i = 0; i < n; ++i) {
            string = string + " ";
        }
        string = string + this.getId() + " log-likelihood = " + d;
        if (n == 0) {
            string = string + "\n\n";
        }
        if (n == 0) {
            string = string + "\n";
            string = string + "likelihood: ";
            string = string + this.getLogLikelihood();
            string = string + "\n\n";
        }
        return string;
    }

    @Override
    public void setId(String string) {
        this.id = string;
    }

    @Override
    public String getId() {
        return this.id;
    }

    class LikelihoodCaller
    implements Callable<Double> {
        private final Likelihood likelihood;
        private final int index;

        public LikelihoodCaller(Likelihood likelihood, int n) {
            this.likelihood = likelihood;
            this.index = n;
        }

        @Override
        public Double call() throws Exception {
            long l = System.nanoTime();
            double d = this.likelihood.getLogLikelihood();
            int n = this.index;
            CompoundLikelihood.this.evaluationTimes[n] = CompoundLikelihood.this.evaluationTimes[n] + (System.nanoTime() - l);
            int n2 = this.index;
            CompoundLikelihood.this.evaluationCounts[n2] = CompoundLikelihood.this.evaluationCounts[n2] + 1;
            return d;
        }
    }

    private class LikelihoodColumn
    extends NumberColumn
    implements Keywordable {
        public LikelihoodColumn(String string) {
            super(string);
        }

        @Override
        public double getDoubleValue() {
            return CompoundLikelihood.this.getLogLikelihood();
        }

        @Override
        public void addKeyword(String string) {
            throw new UnsupportedOperationException("Can't add keywords here");
        }

        @Override
        public List<String> getKeywords() {
            return CompoundLikelihood.this.getKeywords();
        }
    }
}

