/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.model;

import dr.inference.model.MatrixParameterInterface;
import dr.inference.model.Statistic;
import dr.inference.model.Variable;
import dr.inference.model.VariableListener;
import dr.math.matrixAlgebra.Vector;
import dr.util.HeapSort;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.ElementRule;
import dr.xml.Reportable;
import dr.xml.XMLObject;
import dr.xml.XMLSyntaxRule;
import org.ejml.data.DenseMatrix64F;
import org.ejml.factory.DecompositionFactory;
import org.ejml.interfaces.decomposition.SingularValueDecomposition;

public class SVDStatistic
extends Statistic.Abstract
implements VariableListener,
Reportable {
    private final MatrixParameterInterface parameter;
    private final double[] singularVals;
    private final double[] Vbuffer;
    private boolean svdKnown = false;
    private static String SINGULAR_VALUE = "sv";
    private static String V = "V";
    public static final String SVD_STATISTIC = "svdStatistic";
    public static AbstractXMLObjectParser PARSER = new AbstractXMLObjectParser(){

        @Override
        public Object parseXMLObject(XMLObject xMLObject) {
            MatrixParameterInterface matrixParameterInterface = (MatrixParameterInterface)xMLObject.getChild(MatrixParameterInterface.class);
            return new SVDStatistic(matrixParameterInterface);
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return new XMLSyntaxRule[]{new ElementRule(MatrixParameterInterface.class)};
        }

        @Override
        public String getParserDescription() {
            return "Statistic that computes and returns the SVD of a given parameter.";
        }

        @Override
        public Class getReturnType() {
            return SVDStatistic.class;
        }

        @Override
        public String getParserName() {
            return SVDStatistic.SVD_STATISTIC;
        }
    };

    SVDStatistic(MatrixParameterInterface matrixParameterInterface) {
        this.parameter = matrixParameterInterface;
        this.singularVals = new double[matrixParameterInterface.getColumnDimension()];
        this.Vbuffer = new double[matrixParameterInterface.getRowDimension() * matrixParameterInterface.getColumnDimension()];
        matrixParameterInterface.addParameterListener(this);
    }

    @Override
    public String getDimensionName(int n) {
        int n2 = this.parameter.getColumnDimension();
        int n3 = this.parameter.getRowDimension();
        if (n < n2) {
            return this.getStatisticName() + "." + SINGULAR_VALUE + (n + 1);
        }
        int n4 = (n - n2) / n3;
        int n5 = n - n2 - n4 * n3;
        return this.getStatisticName() + "." + V + (n4 + 1) + (n5 + 1);
    }

    @Override
    public int getDimension() {
        int n = this.parameter.getColumnDimension();
        int n2 = this.parameter.getRowDimension();
        return n + n * n2;
    }

    @Override
    public double getStatisticValue(int n) {
        int n2;
        if (!this.svdKnown) {
            this.recomputeStatistic();
            this.enforceConstraints();
            this.svdKnown = true;
        }
        if (n < (n2 = this.parameter.getColumnDimension())) {
            return this.singularVals[n];
        }
        return this.Vbuffer[n - n2];
    }

    private void recomputeStatistic() {
        double[] dArray = this.parameter.getParameterValues();
        int n = this.parameter.getColumnDimension();
        int n2 = this.parameter.getRowDimension();
        DenseMatrix64F denseMatrix64F = DenseMatrix64F.wrap(n, n2, dArray);
        DenseMatrix64F denseMatrix64F2 = DenseMatrix64F.wrap(n, n2, this.Vbuffer);
        SingularValueDecomposition<DenseMatrix64F> singularValueDecomposition = DecompositionFactory.svd(denseMatrix64F.numRows, denseMatrix64F.numCols, false, true, true);
        singularValueDecomposition.decompose(denseMatrix64F);
        System.arraycopy(singularValueDecomposition.getSingularValues(), 0, this.singularVals, 0, n);
        singularValueDecomposition.getV(denseMatrix64F2, true);
    }

    private void enforceConstraints() {
        int n;
        int n2 = this.parameter.getColumnDimension();
        int n3 = this.parameter.getRowDimension();
        for (n = 1; n < n2; ++n) {
            if (!(this.singularVals[n] > this.singularVals[n - 1])) continue;
            this.reorderSVD();
            break;
        }
        for (n = 0; n < n2; ++n) {
            int n4 = n * n3;
            if (!(this.Vbuffer[n4] < 0.0)) continue;
            for (int i = n4; i < n4 + n3; ++i) {
                this.Vbuffer[i] = -this.Vbuffer[i];
            }
        }
    }

    private void reorderSVD() {
        int n = this.parameter.getColumnDimension();
        int n2 = this.parameter.getRowDimension();
        int[] nArray = new int[n];
        HeapSort.sort(this.singularVals, nArray);
        for (int i = 0; i < n; ++i) {
            nArray[i] = n - nArray[i] - 1;
        }
        double[] dArray = new double[n];
        double[] dArray2 = new double[n * n2];
        for (int i = 0; i < n; ++i) {
            dArray[i] = this.singularVals[nArray[i]];
            for (int j = 0; j < n2; ++j) {
                dArray2[i * n2 + j] = this.Vbuffer[nArray[i] * n2 + j];
            }
        }
        System.arraycopy(dArray, 0, this.singularVals, 0, n);
        System.arraycopy(dArray2, 0, this.Vbuffer, 0, n * n2);
    }

    @Override
    public void variableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        this.svdKnown = false;
    }

    @Override
    public String getReport() {
        StringBuilder stringBuilder = new StringBuilder("svdStatistic Report\n\n");
        stringBuilder.append("dimension names: ");
        int n = this.getDimension();
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(this.getDimensionName(i));
            if (i != n - 1) {
                stringBuilder.append(" ");
            }
            dArray[i] = this.getStatisticValue(i);
        }
        stringBuilder.append("\n\n");
        stringBuilder.append("values: ");
        stringBuilder.append(new Vector(dArray));
        stringBuilder.append("\n\n");
        return stringBuilder.toString();
    }
}

