/*
 * Decompiled with CFR 0.152.
 */
package dr.math.distributions;

import dr.math.distributions.NormalDistribution;
import dr.math.distributions.NormalKDEDistribution;
import dr.math.distributions.TransformedNormalKDEDistribution;

public class LogitTransformedNormalKDEDistribution
extends NormalKDEDistribution {
    public static final int MINIMUM_GRID_SIZE = 2048;
    public static final boolean DEBUG = false;
    private double[] finalXPoints;
    private double[] backupXPoints;
    private double[] finalDensityPoints;
    private double[] backupSample;
    private double[] logitSample;
    private boolean transformIncreasing = true;
    private double upperLimit;

    public LogitTransformedNormalKDEDistribution(Double[] doubleArray) {
        this(doubleArray, (Double)1.0, null, null, null);
    }

    public LogitTransformedNormalKDEDistribution(Double[] doubleArray, Double d) {
        this(doubleArray, d, null, null, null);
    }

    public LogitTransformedNormalKDEDistribution(Double[] doubleArray, int n) {
        this(doubleArray, 1.0, null, null, null, 3.0, n);
    }

    public LogitTransformedNormalKDEDistribution(Double[] doubleArray, Double d, int n) {
        this(doubleArray, d, null, null, null, 3.0, n);
    }

    public LogitTransformedNormalKDEDistribution(Double[] doubleArray, Double d, Double d2, Double d3, Double d4) {
        this(doubleArray, d, d2, d3, d4, 3.0, 2048);
    }

    public LogitTransformedNormalKDEDistribution(Double[] doubleArray, Double d, Double d2, Double d3, Double d4, int n) {
        this(doubleArray, d, d2, d3, d4, 3.0, n);
    }

    public LogitTransformedNormalKDEDistribution(Double[] doubleArray, Double d, Double d2, Double d3, Double d4, double d5, int n) {
        super(LogitTransformedNormalKDEDistribution.getLogit(doubleArray, d), d2, d3, d4);
        this.upperLimit = d;
        this.logitSample = this.sample;
        this.backupSample = new double[doubleArray.length];
        for (int i = 0; i < doubleArray.length; ++i) {
            this.backupSample[i] = doubleArray[i];
        }
        this.densityKnown = false;
        this.computeDensity();
    }

    private static Double[] getLogit(Double[] doubleArray, double d) {
        Double[] doubleArray2 = new Double[doubleArray.length];
        for (int i = 0; i < doubleArray2.length; ++i) {
            doubleArray2[i] = Math.log(doubleArray[i] / (d - doubleArray[i]));
        }
        return doubleArray2;
    }

    @Override
    public double getFromPoint() {
        return this.from;
    }

    @Override
    public double getToPoint() {
        return this.to;
    }

    @Override
    protected void computeDensity() {
        this.makeOrdinates();
        this.makeXGrid();
        this.transformData();
        this.transformEstimator();
        this.densityKnown = true;
    }

    private void transformEstimator() {
        int n;
        this.sample = this.backupSample;
        this.setBandWidth(null);
        this.setBounds();
        this.backupXPoints = new double[this.xPoints.length];
        System.arraycopy(this.xPoints, 0, this.backupXPoints, 0, this.xPoints.length);
        this.makeXGrid();
        int n2 = 0;
        for (n = 0; n < this.xPoints.length; ++n) {
            if (!(this.xPoints[n] < 0.0)) continue;
            ++n2;
        }
        this.finalXPoints = new double[this.xPoints.length - n2];
        System.arraycopy(this.xPoints, n2, this.finalXPoints, 0, this.xPoints.length - n2);
        this.finalDensityPoints = new double[this.densityPoints.length - n2];
        for (n = 0; n < this.finalXPoints.length; ++n) {
            this.finalDensityPoints[n] = this.linearApproximate(this.backupXPoints, this.densityPoints, Math.log(this.finalXPoints[n] / (this.upperLimit - this.finalXPoints[n])), 0.0, 0.0) * (1.0 / (this.finalXPoints[n] * (this.upperLimit - this.finalXPoints[n])));
        }
    }

    @Override
    protected void processBounds(Double d, Double d2) {
        if (d != null && d != Double.NEGATIVE_INFINITY || d2 != null && d2 != Double.POSITIVE_INFINITY) {
            throw new RuntimeException("LogitTransformedNormalKDEDistribution must be unbounded");
        }
    }

    @Override
    protected void setBandWidth(Double d) {
        this.resetIndices(this.transformIncreasing);
        super.setBandWidth(d);
    }

    public static void main(String[] stringArray) {
        Double d;
        int n;
        int n2;
        double d2 = 3.0;
        Double[] doubleArray = new Double[2001];
        NormalDistribution normalDistribution = new NormalDistribution(0.5, 0.08);
        for (n2 = 0; n2 < doubleArray.length; ++n2) {
            doubleArray[n2] = d2 - Math.abs((Double)normalDistribution.nextRandom() - 0.5);
        }
        System.out.print("par(mfrow=c(2,3))\n\nsamples <- c(");
        for (n2 = 0; n2 < doubleArray.length - 1; ++n2) {
            System.out.print(doubleArray[n2] + ",");
            if (n2 % 10 != 0) continue;
            System.out.print("\n");
        }
        System.out.println(doubleArray[doubleArray.length - 1] + ")\n");
        System.out.println("hist(samples,200,xlim=c(" + (d2 - 0.5) + "," + (d2 + 0.5) + "))\n");
        System.out.println("plot(density(samples),xlim=c(" + (d2 - 0.5) + "," + (d2 + 0.5) + "))\n");
        LogitTransformedNormalKDEDistribution logitTransformedNormalKDEDistribution = new LogitTransformedNormalKDEDistribution(doubleArray, d2);
        TransformedNormalKDEDistribution transformedNormalKDEDistribution = TransformedNormalKDEDistribution.getLogitTransformedNormalKDEDistribution(doubleArray, d2);
        NormalKDEDistribution normalKDEDistribution = new NormalKDEDistribution(doubleArray);
        System.out.print("normalKDE <- c(");
        for (n = ((int)d2 - 1) * 1000; n < ((int)d2 + 1) * 1000; ++n) {
            d = 0.0 + (double)n / 1000.0;
            System.out.print(normalKDEDistribution.evaluateKernel(d) + ",");
            if (n % 10 != 0) continue;
            System.out.print("\n");
        }
        System.out.println(normalKDEDistribution.evaluateKernel((double)(((int)d2 + 1) * 1000) / (d2 * 1000.0)) + ")\n");
        System.out.println("index <- seq(" + (d2 - 1.0) + "," + (d2 + 1.0) + ",by=0.001)");
        System.out.println("plot(index,normalKDE,type=\"l\",xlim=c(" + (d2 - 0.5) + "," + (d2 + 0.5) + "))\n");
        System.out.print("TransKDEOld <- c(");
        for (n = ((int)d2 - 1) * 1000; n < ((int)d2 + 1) * 1000; ++n) {
            d = 0.0 + (double)n / 1000.0;
            System.out.print(logitTransformedNormalKDEDistribution.evaluateKernel(d) + ",");
            if (n % 10 != 0) continue;
            System.out.print("\n");
        }
        System.out.println(logitTransformedNormalKDEDistribution.evaluateKernel((double)(((int)d2 + 1) * 1000) / (d2 * 1000.0)) + ")\n");
        System.out.println("plot(index,TransKDEOld,type=\"l\",xlim=c(" + (d2 - 0.5) + "," + (d2 + 0.5) + "))\n");
        System.out.print("TransKDENew <- c(");
        for (n = ((int)d2 - 1) * 1000; n < ((int)d2 + 1) * 1000; ++n) {
            d = 0.0 + (double)n / 1000.0;
            System.out.print(transformedNormalKDEDistribution.evaluateKernel(d) + ",");
            if (n % 10 != 0) continue;
            System.out.print("\n");
        }
        System.out.println(transformedNormalKDEDistribution.evaluateKernel((double)(((int)d2 + 1) * 1000) / (d2 * 1000.0)) + ")\n");
        System.out.println("plot(index,TransKDENew,type=\"l\",xlim=c(" + (d2 - 0.5) + "," + (d2 + 0.5) + "))\n");
    }
}

