/*
 * Decompiled with CFR 0.152.
 */
package dr.oldevomodel.treelikelihood;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evomodel.branchratemodel.BranchRateModel;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.oldevomodel.sitemodel.SiteModel;
import dr.oldevomodel.substmodel.SubstitutionModel;
import dr.oldevomodel.treelikelihood.TreeBranchSubstitutionModel;
import java.util.List;

@Deprecated
public class EpochTreeBranchSubstitutionModel
extends TreeBranchSubstitutionModel {
    public static final boolean DEBUG = false;
    private List<SubstitutionModel> modelList;
    private Parameter transitionTimesParameter;
    private double[] transitionTimes;
    private double[] weight;
    private double[] stepMatrix;
    private double[] productMatrix;
    private double[] resultMatrix;
    private int numberModels;
    private int stateCount;

    public EpochTreeBranchSubstitutionModel(String string, SiteModel siteModel, List<SubstitutionModel> list, BranchRateModel branchRateModel, Parameter parameter) {
        super(string, siteModel, null, branchRateModel);
        this.modelList = list;
        this.transitionTimesParameter = parameter;
        this.transitionTimes = this.transitionTimesParameter.getParameterValues();
        this.addVariable(parameter);
        for (SubstitutionModel substitutionModel : this.modelList) {
            this.addModel(substitutionModel);
        }
        this.numberModels = this.modelList.size();
        this.weight = new double[this.numberModels];
        this.stateCount = this.modelList.get(0).getDataType().getStateCount();
        this.stepMatrix = new double[this.stateCount * this.stateCount];
        this.productMatrix = new double[this.stateCount * this.stateCount];
        this.resultMatrix = new double[this.stateCount * this.stateCount];
    }

    @Override
    public void getTransitionProbabilities(Tree tree, NodeRef nodeRef, int n, double[] dArray) {
        double d;
        double d2;
        NodeRef nodeRef2 = tree.getParent(nodeRef);
        double d3 = this.branchModel.getBranchRate(tree, nodeRef);
        double d4 = d3 * ((d2 = tree.getNodeHeight(nodeRef2)) - (d = tree.getNodeHeight(nodeRef)));
        if (d4 < 0.0) {
            throw new RuntimeException("Negative branch length: " + d4);
        }
        double d5 = this.siteModel.getRateForCategory(n) * d4;
        int n2 = 0;
        boolean bl = this.getEpochWeights(d2, d, this.weight) == 1;
        for (int i = 0; i < this.numberModels; ++i) {
            if (!(this.weight[i] > 0.0)) continue;
            SubstitutionModel substitutionModel = this.modelList.get(i);
            if (n2 == 0) {
                if (bl) {
                    substitutionModel.getTransitionProbabilities(d5, dArray);
                    break;
                }
                substitutionModel.getTransitionProbabilities(d5 * this.weight[i], this.resultMatrix);
                ++n2;
                continue;
            }
            substitutionModel.getTransitionProbabilities(d5 * this.weight[i], this.stepMatrix);
            int n3 = 0;
            for (int j = 0; j < this.stateCount; ++j) {
                for (int k = 0; k < this.stateCount; ++k) {
                    this.productMatrix[n3] = 0.0;
                    for (int i2 = 0; i2 < this.stateCount; ++i2) {
                        int n4 = n3;
                        this.productMatrix[n4] = this.productMatrix[n4] + this.resultMatrix[j * this.stateCount + i2] * this.stepMatrix[i2 * this.stateCount + k];
                    }
                    ++n3;
                }
            }
            double[] dArray2 = this.resultMatrix;
            this.resultMatrix = this.productMatrix;
            this.productMatrix = dArray2;
        }
        if (!bl) {
            System.arraycopy(this.resultMatrix, 0, dArray, 0, this.stateCount * this.stateCount);
        }
    }

    private int getEpochWeights(double d, double d2, double[] dArray) {
        int n = 0;
        double d3 = d2 - d;
        int n2 = this.numberModels - 2;
        if (d <= this.transitionTimes[0]) {
            dArray[0] = d2 <= this.transitionTimes[0] ? 1.0 : (this.transitionTimes[0] - d) / d3;
            ++n;
        } else {
            dArray[0] = 0.0;
        }
        for (int i = 1; i <= n2; ++i) {
            if (d <= this.transitionTimes[i]) {
                double d4 = Math.max(d, this.transitionTimes[i - 1]);
                double d5 = Math.min(d2, this.transitionTimes[i]);
                dArray[i] = (d5 - d4) / d3;
                ++n;
                continue;
            }
            dArray[i] = 0.0;
        }
        if (n2 >= 0) {
            if (d2 > this.transitionTimes[n2]) {
                double d6 = Math.max(d, this.transitionTimes[n2]);
                dArray[n2 + 1] = (d2 - d6) / d3;
                ++n;
            } else {
                dArray[n2 + 1] = 0.0;
            }
        }
        return n;
    }

    @Override
    protected final void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        super.handleVariableChangedEvent(variable, n, changeType);
        if (variable == this.transitionTimesParameter) {
            this.transitionTimes = this.transitionTimesParameter.getParameterValues();
            this.fireModelChanged(variable, n);
        }
    }
}

