/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer.widgets.param;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.rosuda.JGR.layout.AnchorConstraint;
import org.rosuda.JGR.layout.AnchorLayout;
import org.rosuda.deducer.Deducer;
import org.rosuda.deducer.WindowTracker;
import org.rosuda.deducer.toolkit.HelpButton;
import org.rosuda.deducer.toolkit.OkayCancelPanel;
import org.rosuda.deducer.widgets.param.ParamWidget;
import org.rosuda.deducer.widgets.param.RFunction;

public class RFunctionDialog
extends JDialog
implements ActionListener {
    protected JPanel panel;
    protected OkayCancelPanel okayCancel;
    protected HelpButton help;
    protected ParamWidget view;
    protected RFunction initialModel;
    protected RFunction model;
    private boolean isRun = true;

    public RFunctionDialog(JFrame jFrame, RFunction rFunction) {
        super(jFrame);
        this.initGUI();
        this.setModel(rFunction);
        this.setRun(true);
    }

    public RFunctionDialog(RFunction rFunction) {
        this.initGUI();
        this.setModel(rFunction);
        this.setRun(true);
    }

    private void initGUI() {
        try {
            AnchorLayout anchorLayout = new AnchorLayout();
            this.getContentPane().setLayout((LayoutManager)anchorLayout);
            this.help = new HelpButton("");
            this.getContentPane().add((Component)this.help, new AnchorConstraint(923, 92, 12, 12, 0, 0, 2, 2));
            this.help.setPreferredSize(new Dimension(29, 26));
            this.help.setVisible(false);
            this.okayCancel = new OkayCancelPanel(false, false, this);
            this.getContentPane().add((Component)this.okayCancel, new AnchorConstraint(923, 21, 0, 521, 0, 2, 2, 0));
            this.okayCancel.setPreferredSize(new Dimension(195, 38));
            this.panel = new JPanel();
            BorderLayout borderLayout = new BorderLayout();
            this.panel.setLayout(borderLayout);
            this.getContentPane().add((Component)this.panel, new AnchorConstraint(1, 994, 44, 1, 1, 1, 2, 1));
            this.panel.setPreferredSize(new Dimension(447, 449));
            this.setSize(450, 515);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setModel(RFunction rFunction) {
        this.initialModel = (RFunction)rFunction.clone();
        this.panel.removeAll();
        this.view = rFunction.getView();
        this.panel.add(this.view);
        this.model = rFunction;
        this.setTitle(rFunction.getName());
        this.validate();
        this.repaint();
    }

    public void setToInitialModel() {
        RFunction rFunction = (RFunction)this.initialModel.clone();
        this.setModel(rFunction);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == "OK") {
            this.view.updateModel();
            String string2 = ((RFunction)this.view.getModel()).checkValid();
            if (string2 != null) {
                JOptionPane.showMessageDialog(this, string2);
            } else {
                this.initialModel = (RFunction)this.model.clone();
                this.dispose();
            }
        } else if (string == "Cancel") {
            this.setToInitialModel();
            this.dispose();
        } else if (string == "Run") {
            this.view.updateModel();
            String string3 = ((RFunction)this.view.getModel()).checkValid();
            if (string3 != null) {
                JOptionPane.showMessageDialog(this, string3);
            } else {
                this.initialModel = (RFunction)this.model.clone();
                this.dispose();
                Deducer.execute(this.model.getCall());
            }
        }
    }

    public HelpButton getHelpButton() {
        return this.help;
    }

    public void setRun(boolean bl) {
        if (bl) {
            this.okayCancel.getApproveButton().setText("Run");
        } else {
            this.okayCancel.getApproveButton().setText("OK");
        }
        this.isRun = bl;
    }

    public boolean isRun() {
        return this.isRun;
    }

    public void run() {
        try {
            if (this.initialModel != null) {
                this.setToInitialModel();
            }
            this.setVisible(true);
            if (!Deducer.isJGR()) {
                WindowTracker.addWindow(this);
                WindowTracker.waitForAllClosed();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

