## ----echo=FALSE, message=FALSE, warning=FALSE---------------------------------
# Ensure the temporary library from R CMD check is visible (esp. on Windows)
libdir <- Sys.getenv("R_LIBS")
if (nzchar(libdir)) {
  parts <- strsplit(libdir, .Platform$path.sep, fixed = TRUE)[[1]]
  .libPaths(unique(c(parts, .libPaths())))
}

# now load your package
suppressPackageStartupMessages(library(ecotourism))


## ----echo=TRUE, eval=TRUE, message=FALSE, warning=FALSE-----------------------
library(dplyr)
library(ecotourism)

data("tourism_region")
tourism_region |> glimpse()


## ----echo=TRUE, eval=TRUE, message=FALSE, warning=FALSE-----------------------
data("tourism_quarterly")
tourism_quarterly |> glimpse()


## ----echo=FALSE, eval=TRUE, message=FALSE, warning=FALSE----------------------

tourism <- tourism_quarterly |>
  left_join(tourism_region, by = c("region_id", "ws_id")) |>
  filter(!is.na(region))

glimpse(tourism)


## ----echo=FALSE, eval=TRUE, message=FALSE, warning=FALSE----------------------

  tourism <- tourism |>
    dplyr::left_join(ecotourism::weather_stations, by = "ws_id")


## ----echo=TRUE, fig.width=6, fig.height=4, eval=FALSE-------------------------
# library(ggplot2)
# library(ggthemes)
# 
# ggplot() +
#   geom_sf(data = oz_lga) +
#   geom_point(data = tourism, aes(x = lon, y = lat),
#                alpha = 0.8, size = 0.5) +
#   theme_map()


## ----echo=TRUE, fig.width=6, fig.height=4, eval=TRUE--------------------------
library(ggplot2)
library(ggthemes)

ggplot() +
    geom_sf(data = oz_lga) +
    geom_point(data = tourism, aes(x = lon, y = lat),
               alpha = 0.5, size = 0.4, color = "blue") +
    geom_point(data = tourism, aes(x = stn_lon, y = stn_lat),
               shape = 17, size = 0.5, alpha = 0.5, color = "red") +
  theme_map()

