# Example script for fuzzyls package

# Simulate some crisp data
set.seed(123)
X_crisp <- matrix(round(runif(300, 2, 10)), nrow = 100, ncol = 3)
beta <- c(1.5, -0.8, 2.0)
Y_crisp <- round(X_crisp %*% beta + rnorm(100, mean = 0, sd = 1))

# Fuzzify the data
X_fuzzy <- fuzzify_crisp_matrix(X_crisp, spread = 1)
Y_fuzzy <- fuzzify_crisp_vector(Y_crisp, spread = 1)

# Fit the fuzzy linear regression model (this step defines 'object')
object <- fuzzy_lm(X_fuzzy, Y_fuzzy, p = 3)

# Now you can use the 'object' for predictions, coefficients, etc.
predictions <- compute_pred(object, X_fuzzy)
summary(object)
coefficients(object)
residuals(object)
predictions(object)

