/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.converter;

public class XMLUtil {
    private XMLUtil() {
    }

    public static String createTagName(String string) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            boolean valid;
            char c = string.charAt(i);
            boolean bl = valid = i == 0 ? XMLUtil.isTagNameStartChar(c) : XMLUtil.isTagNameContinuationChar(c);
            if (valid) {
                sb.append(c);
                continue;
            }
            if (c == ' ') {
                sb.append("_x0020_");
                continue;
            }
            sb.append('_');
            sb.append('x');
            String hex = Integer.toHexString(c);
            for (int j = 0; j < 4 - hex.length(); ++j) {
                sb.append('0');
            }
            sb.append(hex);
            sb.append('_');
        }
        return sb.toString();
    }

    private static boolean isTagNameStartChar(char c) {
        switch (c) {
            case '_': {
                return true;
            }
        }
        return Character.isLetter(c);
    }

    private static boolean isTagNameContinuationChar(char c) {
        switch (c) {
            case '-': 
            case '.': 
            case '_': {
                return true;
            }
        }
        return Character.isLetterOrDigit(c);
    }
}

