/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.binary;

import org.chocosolver.sat.Reason;
import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Explained;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.delta.IIntDeltaMonitor;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.procedure.IntProcedure;
import org.chocosolver.util.tools.ArrayUtils;

@Explained
public final class PropEqualX_Y
extends Propagator<IntVar> {
    private final IntVar x;
    private final IntVar y;
    private boolean bothEnumerated;
    private IIntDeltaMonitor[] idms;
    private IntProcedure rem_proc;
    private int indexToFilter;

    public PropEqualX_Y(IntVar x, IntVar y) {
        super((Variable[])ArrayUtils.toArray(x, y), (Priority)PropagatorPriority.BINARY, true);
        this.x = ((IntVar[])this.vars)[0];
        this.y = ((IntVar[])this.vars)[1];
        if (x.hasEnumeratedDomain() && y.hasEnumeratedDomain()) {
            this.bothEnumerated = true;
            this.idms = new IIntDeltaMonitor[2];
            this.idms[0] = ((IntVar[])this.vars)[0].monitorDelta(this);
            this.idms[1] = ((IntVar[])this.vars)[1].monitorDelta(this);
            this.rem_proc = i -> ((IntVar[])this.vars)[this.indexToFilter].removeValue(i, this, this.lcg() ? Reason.r(((IntVar[])this.vars)[1 - this.indexToFilter].getLit(i, 0)) : Reason.undef());
        }
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        if (((IntVar[])this.vars)[0].hasEnumeratedDomain() && ((IntVar[])this.vars)[1].hasEnumeratedDomain()) {
            return IntEventType.all();
        }
        return IntEventType.boundAndInst();
    }

    private void updateBounds() throws ContradictionException {
        while (this.x.updateLowerBound(this.y.getLB(), this, this.lcg() ? Reason.r(this.y.getMinLit()) : Reason.undef()) | this.y.updateLowerBound(this.x.getLB(), this, this.lcg() ? Reason.r(this.x.getMinLit()) : Reason.undef())) {
        }
        while (this.x.updateUpperBound(this.y.getUB(), this, this.lcg() ? Reason.r(this.y.getMaxLit()) : Reason.undef()) | this.y.updateUpperBound(this.x.getUB(), this, this.lcg() ? Reason.r(this.x.getMaxLit()) : Reason.undef())) {
        }
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        this.updateBounds();
        if (this.bothEnumerated) {
            int ub = this.x.getUB();
            int val = this.x.getLB();
            while (val <= ub) {
                if (!this.y.contains(val)) {
                    this.x.removeValue(val, this, this.lcg() ? Reason.r(this.y.getLit(val, 0)) : Reason.undef());
                }
                val = this.x.nextValue(val);
            }
            ub = this.y.getUB();
            val = this.y.getLB();
            while (val <= ub) {
                if (!this.x.contains(val)) {
                    this.y.removeValue(val, this, this.lcg() ? Reason.r(this.x.getLit(val, 0)) : Reason.undef());
                }
                val = this.y.nextValue(val);
            }
            this.idms[0].startMonitoring();
            this.idms[1].startMonitoring();
        }
    }

    @Override
    public void propagate(int varIdx, int mask) throws ContradictionException {
        this.updateBounds();
        if (!(!this.bothEnumerated || this.x.isInstantiated() && this.y.isInstantiated())) {
            this.indexToFilter = 1 - varIdx;
            this.idms[varIdx].forEachRemVal(this.rem_proc);
        }
    }

    @Override
    public ESat isEntailed() {
        if (this.x.getUB() < this.y.getLB() || this.x.getLB() > this.y.getUB() || this.x.hasEnumeratedDomain() && this.y.hasEnumeratedDomain() && !this.match()) {
            return ESat.FALSE;
        }
        if (this.x.isInstantiated() && this.y.isInstantiated() && this.x.getValue() == this.y.getValue()) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }

    private boolean match() {
        int lb = this.x.getLB();
        int ub = this.x.getUB();
        while (lb <= ub) {
            if (this.y.contains(lb)) {
                return true;
            }
            lb = this.x.nextValue(lb);
        }
        return false;
    }

    @Override
    public String toString() {
        return "prop(" + ((IntVar[])this.vars)[0].getName() + ".EQ." + ((IntVar[])this.vars)[1].getName() + ")";
    }
}

