/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.strategy.strategy;

import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;
import java.util.HashMap;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.search.loop.monitors.IMonitorSolution;
import org.chocosolver.solver.search.strategy.assignments.DecisionOperatorFactory;
import org.chocosolver.solver.search.strategy.decision.Decision;
import org.chocosolver.solver.search.strategy.decision.IntDecision;
import org.chocosolver.solver.search.strategy.strategy.AbstractStrategy;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;

public class WarmStart
extends AbstractStrategy<Variable>
implements IMonitorSolution {
    private final HashMap<Variable, Object> hints;
    private AbstractStrategy<Variable> mainStrategy;
    private long solCount;
    private final Solver solver;

    public WarmStart(Solver solver) {
        super(new Variable[0]);
        this.solver = solver;
        this.hints = new HashMap();
    }

    public void setStrategy(AbstractStrategy<Variable> strategy) {
        this.mainStrategy = strategy;
    }

    public AbstractStrategy<Variable> getStrategy() {
        return this.mainStrategy;
    }

    @Override
    public boolean init() {
        if (!this.solver.getSearchMonitors().contains(this)) {
            this.solver.plugMonitor(this);
        }
        return this.mainStrategy.init();
    }

    @Override
    public void remove() {
        this.mainStrategy.remove();
        if (this.solver.getSearchMonitors().contains(this)) {
            this.solver.unplugMonitor(this);
        }
    }

    public void addHint(IntVar var, int o) {
        if (var.isAConstant()) {
            return;
        }
        TIntList values = (TIntList)this.hints.get(var);
        if (values == null) {
            values = new TIntArrayList();
            this.hints.put(var, values);
        }
        if (!values.contains(o)) {
            values.add(o);
        }
    }

    public void clearHints() {
        this.hints.clear();
    }

    @Override
    public Decision getDecision() {
        Variable var;
        IntDecision dec = this.mainStrategy.getDecision();
        if (this.solCount < 1L && dec != null && this.hints.containsKey(var = dec.getDecisionVariable()) && var instanceof IntVar) {
            int[] values;
            IntVar iv = (IntVar)var;
            for (int v : values = ((TIntList)this.hints.get(var)).toArray()) {
                if (!iv.contains(v)) continue;
                ((Decision)dec).free();
                dec = this.solver.getDecisionPath().makeIntDecision(iv, DecisionOperatorFactory.makeIntEq(), v);
                break;
            }
        }
        return dec;
    }

    public Variable[] getVariables() {
        return this.mainStrategy.getVariables();
    }

    @Override
    public void onSolution() {
        ++this.solCount;
    }
}

