## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  out.width = "100%"
)

## ----setup--------------------------------------------------------------------
library(unsum)

## -----------------------------------------------------------------------------
data <- closure_generate(
  mean = "3.5",
  sd = "1.8",
  n = 80,
  scale_min = 1,
  scale_max = 5
)

## -----------------------------------------------------------------------------
closure_plot_bar(data)

## -----------------------------------------------------------------------------
data

## -----------------------------------------------------------------------------
closure_plot_ecdf(data)

## -----------------------------------------------------------------------------
data_horns <- closure_horns_analyze(data)
data_horns

## -----------------------------------------------------------------------------
closure_horns_histogram(data_horns)

## -----------------------------------------------------------------------------
# Using a temporary folder via `tempdir()` just for this example --
# you should use a real folder on your computer instead!
path_new_folder <- closure_write(data, path = tempdir())

## -----------------------------------------------------------------------------
data_new <- closure_read(path_new_folder)

