## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  fig.align = "center"
)

## ----setup--------------------------------------------------------------------
# Install and load PERSUADE
# devtools::install_github("Bram-R/PERSUADE", quiet = TRUE) # To install the development version of PERSUADE
# install.packages("PERSUADE") # To install CRAN version of PERSUADE
library(PERSUADE)

## ----data---------------------------------------------------------------------
# Example dataset
years  <- flexsurv::bc$recyrs   # time to event
status <- flexsurv::bc$censrec  # event indicator
group  <- flexsurv::bc$group    # grouping variable

## ----settings-----------------------------------------------------------------
name <- "BC_OS"        # project name
time_pred_surv_table <- c(0, 1, 2, 3, 4, 5, 10, 15, 20, 25, 30, 35)  # survival table times
time_unit    <- 1/12   # monthly data in years
time_horizon <- 40     # analysis horizon (years)

## ----f_PERSUADE, eval=FALSE---------------------------------------------------
# PERSUADE <- f_PERSUADE(
#   name = name,
#   years = years,
#   status = status,
#   group = group,
#   strata = FALSE,
#   spline_mod = TRUE,
#   cure_mod = TRUE,
#   cure_link = "logistic", # options: "logistic", "loglog", "identity", "probit"
#   time_unit = time_unit,
#   time_horizon = time_horizon,
#   time_pred_surv_table = time_pred_surv_table
# )

## ----PERSUADE_res, eval=FALSE-------------------------------------------------
# print(PERSUADE)
# summary(PERSUADE, type = "km")
# summary(PERSUADE, type = "gof")

## ----PERSUADE_plot, eval=FALSE------------------------------------------------
# palette(rainbow(n = 9, s = 1, v = 1, start = 0, end = max(1, 9 - 1)/9, alpha = 1)) # Set colour palette for Figures
# plot(PERSUADE, type = "km")            # Kaplan-Meier
# plot(PERSUADE, type = "ph")            # Proportional hazards
# plot(PERSUADE, type = "hr")            # Hazard functions
# plot(PERSUADE, type = "param_models")  # Standard parametric fits
# plot(PERSUADE, type = "spline_models") # Spline-based fits
# plot(PERSUADE, type = "cure_models")   # Cure models
# palette("default") # Set colour palette to default

## ----PERSUADE_report, eval=FALSE----------------------------------------------
# f_generate_report(PERSUADE)

## ----PERSUADE_export, eval=FALSE----------------------------------------------
# write.csv(PERSUADE$surv_model_excel,
#           file.path(tempdir(), paste0(name, "_output"),
#                     "PERSUADE_Time-to-event_models_parameters_comma.csv"))
# write.csv2(PERSUADE$surv_model_excel,
#            file.path(tempdir(), paste0(name, "_output"),
#                      "PERSUADE_Time-to-event_models_parameters_semicolon.csv"))

## ----eval=FALSE---------------------------------------------------------------
# f_get_excel_template()

