## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(ggplot2)
library(adaplots)

## ----eval=TRUE, fig.width=7.18, fig.height=4.5--------------------------------
set.seed(2025)
X<-matrix(rnorm(100, mean = 2 , sd = 5))
adaplot(X, title = "Ada-plot", xlab = "x", lcol = "black", rcol = "grey60")

## ----eval=TRUE, fig.width=7.18, fig.height=4.5--------------------------------
set.seed(2025)
X<-matrix(rbeta(100, shape1 = 10, shape2 = 2))
adaplot(X, title = "Ada-plot", xlab = "x", lcol = "black", rcol = "grey60")

## ----eval=TRUE, fig.width=7.18, fig.height=4.5--------------------------------
set.seed(2025)
X<-matrix(rf(100, df1 = 10, df2 = 5))
adaplot(X, title = "Ada-plot", xlab = "x", lcol = "black", rcol = "grey60")

## ----eval=TRUE, fig.width=7.18, fig.height=4.5--------------------------------
set.seed(2030)
X<-matrix(rnorm(30, mean = 2, sd = 5))
udaplot(X, npdf = FALSE, lcol = "black", rcol = "grey60", pdfcol = "red")

## ----eval=TRUE, fig.width=7.18, fig.height=4.5--------------------------------
set.seed(2030)
X<-matrix(rnorm(30, mean = 2, sd = 5))
udaplot(X, npdf = TRUE, lcol = "black", rcol = "grey60", pdfcol = "red")

## ----eval=TRUE, fig.width=7.18, fig.height=4.5--------------------------------
set.seed(2030)
X<-matrix(rnorm(2050, mean = 2, sd = 5))
udaplot(X, npdf = TRUE, lcol = "black", rcol = "grey60", pdfcol = "red")

## ----eval=TRUE, fig.width=7.18, fig.height=4.5--------------------------------
set.seed(2030)
X<-matrix(c(rnorm(50, mean = 2, sd = 5), runif(4, 17, 30)))
udaplot(X, npdf = TRUE, lcol = "black", rcol = "grey60", pdfcol = "red")

## ----eval=TRUE, fig.width=7.18, fig.height=4.5--------------------------------
set.seed(2030)
X<-matrix(c(rnorm(50, mean = 2, sd = 5), runif(4, 17, 30)))
udaplot(X, excld = TRUE, npdf = TRUE, lcol = "black", rcol = "grey60", pdfcol = "red")

