## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(ordinalTables)

## ----vision-------------------------------------------------------------------
vision_data

## ----bowker-------------------------------------------------------------------
bowker <- Bowker_symmetry(vision_data)

## ----marginal-----------------------------------------------------------------
stuart <- Stuart_marginal_homogeneity(vision_data)
bhapkar <- Bhapkar_marginal_homogeneity(vision_data)

## ----quasi--------------------------------------------------------------------
quasi <- Bhapkar_quasi_symmetry(vision_data)

## ----quasi2-------------------------------------------------------------------
conditional <- McCullagh_conditional_symmetry(vision_data)
quasi2 <- McCullagh_quasi_symmetry(vision_data)
palindrome <- McCullagh_palindromic_symmetry(vision_data)
gen_palindrome <- McCullagh_generalized_palindromic_symmetry(vision_data)

## ----goodman------------------------------------------------------------------
diagonal <- Goodman_diagonals_parameter_symmetry(vision_data)

equal <- c(FALSE, TRUE, TRUE)
constrained_diagonal <- Goodman_constrained_diagonals_parameter_symmetry(vision_data, equal)

fixed <- c(FALSE, TRUE, FALSE)
delta <- c(1.0, 1.0, 1.0)
fixed_diagonal <- Goodman_fixed_parameter(vision_data, delta, fixed)

## ----agresti_diagonal---------------------------------------------------------
agresti <- Agresti_simple_diagonals_parameter_quasi_symmetry(vision_data)

