/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.buffer.tlong;

import cern.colt.PersistentObject;
import cern.colt.buffer.tlong.LongBuffer2DConsumer;
import cern.colt.list.tlong.LongArrayList;

public class LongBuffer2D
extends PersistentObject
implements LongBuffer2DConsumer {
    private static final long serialVersionUID = 1L;
    protected LongBuffer2DConsumer target;
    protected long[] xElements;
    protected long[] yElements;
    protected LongArrayList xList;
    protected LongArrayList yList;
    protected int capacity;
    protected int size;

    public LongBuffer2D(LongBuffer2DConsumer longBuffer2DConsumer, int n) {
        this.target = longBuffer2DConsumer;
        this.capacity = n;
        this.xElements = new long[n];
        this.yElements = new long[n];
        this.xList = new LongArrayList(this.xElements);
        this.yList = new LongArrayList(this.yElements);
        this.size = 0;
    }

    public void add(long l, long l2) {
        if (this.size == this.capacity) {
            this.flush();
        }
        this.xElements[this.size] = l;
        this.yElements[this.size++] = l2;
    }

    public void addAllOf(LongArrayList longArrayList, LongArrayList longArrayList2) {
        int n = longArrayList.size();
        if (this.size + n >= this.capacity) {
            this.flush();
        }
        this.target.addAllOf(longArrayList, longArrayList2);
    }

    public void clear() {
        this.size = 0;
    }

    public void flush() {
        if (this.size > 0) {
            this.xList.setSize(this.size);
            this.yList.setSize(this.size);
            this.target.addAllOf(this.xList, this.yList);
            this.size = 0;
        }
    }
}

