main_ui_coxph_size <- function(test_type) {
  withMathJax(
    tagList(
      h4("Result"),
      tags$div(
        style = "font-size: 24px; font-weight: bold;",
        textOutput("result")
      ),
      hr(),
      switch(test_type,
             "2-side" = tagList(
               h4("Calculate Sample Size Needed to Test Time-To-Event Data: Cox PH, 2-Sided Equality"),
               p("You can use this calculator to perform power and sample size calculations for a time-to-event analysis, sometimes called survival analysis. A two-group time-to-event analysis involves comparing the time it takes for a certain event to occur between two groups."),
               p("For example, we may be interested in whether there is a difference in recovery time following two different medical treatments. Or, in a marketing analysis we may be interested in whether there is a difference between two marketing campaigns with regards to the time between impression and action, where the action may be, for example, buying a product."),
               p("Since 'time-to-event' methods were originally developed as 'survival' methods, the primary parameter of interest is called the hazard ratio. The hazard is the probability of the event occurring in the next instant given that it hasn't yet occurred. The hazard ratio is then the ratio of the hazards between two groups. Letting \\(\\theta\\) represent the hazard ratio, the hypotheses of interest are"),
               p("$$H_0:\\theta=\\theta_0$$"),
               p("$$H_1:\\theta\\ne \\theta_0$$"),
               p("where \\(\\theta_0\\) is the hazard ratio hypothesized under the null hypothesis. The calculator above and the formulas below use the notation that"),
               p("\\(\\theta\\)	is the hazard ratio"),
               p("\\(\\ln(\\theta)\\)	is the natural logarithm of the hazard ratio, or the log-hazard ratio"),
               p("\\(p_E\\)	is the overall probability of the event occurring within the study period"),
               p("\\(p_A\\) and \\(p_B\\)	are the proportions of the sample size allotted to the two groups, named 'A' and 'B'"),
               p("\\(n\\) is the total sample size"),
               p("Notice that \\(p_B = 1 - p_A\\)."),
               h4("Formulas"),
               p("This calculator uses the following formulas to compute sample size and power, respectively:"),
               p("$$n=\\frac{1}{p_A\\;p_B\\;p_E}\\left(\\frac{z_{1-\\alpha/2}+z_{1-\\beta}}{\\ln(\\theta)-\\ln(\\theta_0)}\\right)^2$$"),
               p("$$1-\\beta= \\Phi\\left( z - z_{1-\\alpha/2} \\right) + \\Phi\\left( -z - z_{1-\\alpha/2} \\right)\\quad ,\\quad z=\\left( \\ln(\\theta) - \\ln(\\theta_0) \\right)\\sqrt{n\\;p_A\\;p_B\\;p_E}$$"),
               p("where"),
               p("\\(n\\) is sample size"),
               p("\\(\\Phi\\) is the standard Normal distribution function"),
               p("\\(\\Phi^{-1}\\) is the standard Normal quantile function"),
               p("\\(\\alpha\\) is Type I error"),
               p("\\(\\beta\\) is Type II error, meaning \\(1-\\beta\\) is power")
             ),
             "non-inferiority" = tagList(
               h4("Calculate Sample Size Needed to Test Time-To-Event Data: Cox PH 1-Sided, non-inferiority, or superiority"),
               p("You can use this calculator to perform power and sample size calculations for a time-to-event analysis, sometimes called survival analysis. A two-group time-to-event analysis involves comparing the time it takes for a certain event to occur between two groups."),
               p("For example, we may be interested in whether there is a difference in recovery time following two different medical treatments. Or, in a marketing analysis we may be interested in whether there is a difference between two marketing campaigns with regards to the time between impression and action, where the action may be, for example, buying a product."),
               p("Since 'time-to-event' methods were originally developed as 'survival' methods, the primary parameter of interest is called the hazard ratio. The hazard is the probability of the event occurring in the next instant given that it hasn't yet occurred. The hazard ratio is then the ratio of the hazards between two groups Letting \\(\\theta\\) represent the hazard ratio, the hypotheses of interest are"),
               p("$$H_0:\\theta=\\theta_0$$"),
               p("$$H_1:\\theta\\gt \\theta_0$$"),
               p("or"),
               p("$$H_0:\\theta=\\theta_0$$"),
               p("$$H_1:\\theta\\lt \\theta_0$$"),
               p("where \\(\\theta_0\\) is the hazard ratio hypothesized under the null hypothesis; \\(\\theta_0\\) can also be viewed as the non-inferiority/superiority margin, just like in the other non-inferiority/superiority calculators here. The calculator above and the formulas below use the notation that"),
               p("\\(\\theta\\)	is the hazard ratio"),
               p("\\(\\ln(\\theta)\\)	is the natural logarithm of the hazard ratio, or the log-hazard ratio"),
               p("\\(p_E\\)	is the overall probability of the event occurring within the study period"),
               p("\\(p_A\\) and \\(p_B\\)	are the proportions of the sample size allotted to the two groups, named 'A' and 'B'"),
               p("\\(n\\) is the total sample size"),
               p("Notice that \\(p_B = 1 - p_A\\)."),
               h4("Formulas"),
               p("This calculator uses the following formulas to compute sample size and power, respectively:"),
               p("$$n=\\frac{1}{p_A\\;p_B\\;p_E}\\left(\\frac{z_{1-\\alpha}+z_{1-\\beta}}{\\ln(\\theta)-\\ln(\\theta_0)}\\right)^2$$"),
               p("$$1-\\beta= \\Phi\\left( z - z_{1-\\alpha} \\right)\\quad ,\\quad z=\\left( \\ln(\\theta) - \\ln(\\theta_0) \\right)\\sqrt{n\\;p_A\\;p_B\\;p_E}$$"),
               p("where"),
               p("\\(n\\) is sample size"),
               p("\\(\\Phi\\) is the standard Normal distribution function"),
               p("\\(\\Phi^{-1}\\) is the standard Normal quantile function"),
               p("\\(\\alpha\\) is Type I error"),
               p("\\(\\beta\\) is Type II error, meaning \\(1-\\beta\\) is power")
             ),
             "equivalence" = tagList(
               h4("Calculate Sample Size Needed to Test Time-To-Event Data: Cox PH, Equivalence"),
               p("You can use this calculator to perform power and sample size calculations for a time-to-event analysis, sometimes called survival analysis. A two-group time-to-event analysis involves comparing the time it takes for a certain event to occur between two groups."),
               p("For example, we may be interested in whether there is a difference in recovery time following two different medical treatments. Or, in a marketing analysis we may be interested in whether there is a difference between two marketing campaigns with regards to the time between impression and action, where the action may be, for example, buying a product."),
               p("Since 'time-to-event' methods were originally developed as 'survival' methods, the primary parameter of interest is called the hazard ratio. The hazard is the probability of the event occurring in the next instant given that it hasn't yet occurred. The hazard ratio is then the ratio of the hazards between two groups Letting \\(\\theta\\) represent the hazard ratio, the hypotheses of interest are"),
               p("$$H_0:|\\ln(\\theta)| \\ge \\delta$$"),
               p("$$H_1:|\\ln(\\theta)| \\lt \\delta$$"),
               p("where \\(\\delta\\) is the equivalence margin, just like in the other equivalence calculators here. The calculator above and the formulas below use the notation that"),
               p("\\(\\theta\\) is the hazard ratio"),
               p("\\(\\ln(\\theta)\\) is the natural logarithm of the hazard ratio, or the log-hazard ratio"),
               p("\\(p_E\\) is the overall probability of the event occurring within the study period"),
               p("\\(p_A\\) and \\(p_B\\) are the proportions of the sample size allotted to the two groups, named 'A' and 'B'"),
               p("\\(n\\) is the total sample size"),
               p("Notice that \\(p_B = 1 - p_A\\)."),
               h4("Formulas"),
               p("This calculator uses the following formulas to compute sample size and power, respectively:"),
               p("$$n=\\frac{1}{p_A\\;p_B\\;p_E}\\left(\\frac{z_{1-\\alpha}+z_{1-\\beta/2}}{\\delta - |\\ln(\\theta)|}\\right)^2$$"),
               p("$$1-\\beta= 2\\Phi\\left( z - z_{1-\\alpha} \\right) - 1\\quad ,\\quad z=\\left( \\delta - |\\ln(\\theta)| \\right)\\sqrt{n\\;p_A\\;p_B\\;p_E}$$"),
               p("where"),
               p("\\(n\\) is sample size"),
               p("\\(\\Phi\\) is the standard Normal distribution function"),
               p("\\(\\Phi^{-1}\\) is the standard Normal quantile function"),
               p("\\(\\alpha\\) is Type I error"),
               p("\\(\\beta\\) is Type II error, meaning \\(1-\\beta\\) is power")
             )
      )
    )
  )
}
