## ----setup, include = FALSE---------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  fig.align = "center",
  fig.width = 8,
  fig.height = 5
)
library(dplyr)
library(ggplot2)
library(redlist)

## ----eval=FALSE---------------------------------------------------------------
# # Load the package
# library(redlist)
# # Get all data on Benin
# benin_rl <- rl_countries(code = "BJ", page = NA)
# 

## ----echo=FALSE---------------------------------------------------------------
benin_rl <- readRDS("benin_full_data.rds")

## -----------------------------------------------------------------------------
# Basic overview
glimpse(benin_rl)

## ----plot-assessments-per-year------------------------------------------------
benin_rl %>%
  count(assessments_year_published) %>%
  ggplot(aes(x = assessments_year_published, y = n)) +
  geom_line(color = "steelblue") +
  geom_point(color = "darkblue") +
  labs(
    title = "Number of assessments per year in Benin",
    x = "Year",
    y = "Number of assessments"
  ) +
  theme_minimal()

## ----plot-category-proportions------------------------------------------------
benin_rl %>%
  filter(!is.na(assessments_red_list_category_code)) %>%
  count(assessments_red_list_category_code) %>%
  mutate(prop = n / sum(n)) %>%
  ggplot(aes(x = reorder(assessments_red_list_category_code, -prop), y = prop)) +
  geom_col(fill = "salmon") +
  scale_y_continuous(labels = scales::percent_format()) +
  labs(
    title = "Proportion of red list categories in Benin",
    x = "Red List Category",
    y = "Proportion"
  ) +
  theme_minimal()

## ----plot-threatened-trends---------------------------------------------------
benin_rl %>%
  filter(assessments_red_list_category_code %in% c("CR", "EN", "VU")) %>%
  count(assessments_year_published, assessments_red_list_category_code) %>%
  ggplot(aes(x = assessments_year_published, y = n,
             color = assessments_red_list_category_code)) +
  geom_line() +
  geom_point() +
  labs(
    title = "Trends of Threatened Categories (CR, EN, VU) Over Time",
    x = "Year",
    y = "Number of Assessments",
    color = "Category"
  ) +
  theme_minimal()

