## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  out.width = "50%"
)

## ----model_constant, fig.cap = "Basic constant model visualisation", include = TRUE, echo = TRUE, results="hide", errors = FALSE, warning = FALSE, message = FALSE, fig.width=4, fig.asp=1.5, fig.align="center"----
library(serofoi)
# Loading and preparing data for modelling
data(chagas2012)

# Model implementation
model_constant <- fit_seromodel(
  serosurvey = chagas2012,
  model_type = "constant"
)
# Visualisation
plot_seromodel(
  model_constant,
  serosurvey = chagas2012,
  bin_serosurvey = TRUE,
  size_text = 6
)

