/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import jakarta.persistence.Query;
import org.springframework.data.jpa.repository.query.JpaParameters;
import org.springframework.data.jpa.repository.query.JpaParametersParameterAccessor;
import org.springframework.data.jpa.repository.query.QueryParameterSetter;
import org.springframework.data.jpa.support.PageableUtils;
import org.springframework.util.Assert;

public class ParameterBinder {
    static final String PARAMETER_NEEDS_TO_BE_NAMED = "For queries with named parameters you need to provide names for method parameters; Use @Param for query method parameters, or when on Java 8+ use the javac flag -parameters";
    private final JpaParameters parameters;
    private final Iterable<QueryParameterSetter> parameterSetters;
    private final boolean useJpaForPaging;

    ParameterBinder(JpaParameters parameters, Iterable<QueryParameterSetter> parameterSetters) {
        this(parameters, parameterSetters, true);
    }

    public ParameterBinder(JpaParameters parameters, Iterable<QueryParameterSetter> parameterSetters, boolean useJpaForPaging) {
        Assert.notNull((Object)((Object)parameters), (String)"JpaParameters must not be null");
        Assert.notNull(parameterSetters, (String)"Parameter setters must not be null");
        this.parameters = parameters;
        this.parameterSetters = parameterSetters;
        this.useJpaForPaging = useJpaForPaging;
    }

    public <T extends Query> T bind(T jpaQuery, QueryParameterSetter.QueryMetadata metadata, JpaParametersParameterAccessor accessor) {
        this.bind(metadata.withQuery(jpaQuery), accessor, QueryParameterSetter.ErrorHandling.STRICT);
        return jpaQuery;
    }

    public void bind(QueryParameterSetter.BindableQuery query, JpaParametersParameterAccessor accessor, QueryParameterSetter.ErrorHandling errorHandling) {
        for (QueryParameterSetter setter : this.parameterSetters) {
            setter.setParameter(query, accessor, errorHandling);
        }
    }

    Query bindAndPrepare(Query query, QueryParameterSetter.QueryMetadata metadata, JpaParametersParameterAccessor accessor) {
        this.bind(query, metadata, accessor);
        if (!this.useJpaForPaging || !this.parameters.hasLimitingParameters() || accessor.getPageable().isUnpaged()) {
            return query;
        }
        query.setFirstResult(PageableUtils.getOffsetAsInteger(accessor.getPageable()));
        query.setMaxResults(accessor.getPageable().getPageSize());
        return query;
    }
}

