/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.spi;

import java.util.HashMap;
import java.util.Map;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.SqlTreeCreationLogger;
import org.hibernate.sql.ast.spi.FromClauseAccess;
import org.hibernate.sql.ast.tree.from.CorrelatedTableGroup;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.jboss.logging.Logger;

public class SimpleFromClauseAccessImpl
implements FromClauseAccess {
    protected final FromClauseAccess parent;
    protected final Map<NavigablePath, TableGroup> tableGroupMap = new HashMap<NavigablePath, TableGroup>();

    public SimpleFromClauseAccessImpl() {
        this(null);
    }

    public SimpleFromClauseAccessImpl(FromClauseAccess parent) {
        this.parent = parent;
    }

    @Override
    public TableGroup findTableGroupOnCurrentFromClause(NavigablePath navigablePath) {
        return this.tableGroupMap.get(navigablePath);
    }

    @Override
    public TableGroup findTableGroup(NavigablePath navigablePath) {
        TableGroup tableGroup = this.tableGroupMap.get(navigablePath);
        if (tableGroup != null || this.parent == null) {
            return tableGroup;
        }
        return this.parent.findTableGroup(navigablePath);
    }

    @Override
    public TableGroup findTableGroupForGetOrCreate(NavigablePath navigablePath) {
        NavigableRole navigableRole;
        TableGroup localTableGroup = this.tableGroupMap.get(navigablePath);
        if (localTableGroup != null || this.parent == null) {
            return localTableGroup;
        }
        TableGroup tableGroup = this.parent.findTableGroup(navigablePath);
        if (tableGroup != null && navigablePath.getParent() != null && (navigableRole = tableGroup.getModelPart().getNavigableRole()).getParent() != null) {
            NavigableRole parentRole = navigableRole.getParent();
            NavigablePath parentPath = navigablePath.getParent();
            while (parentRole.getParent() != null) {
                parentRole = parentRole.getParent();
                parentPath = parentPath.getParent();
            }
            TableGroup parentFound = this.parent.findTableGroup(parentPath);
            if (parentFound == null || this.getCorrelatedTableGroup(parentFound) == this.getCorrelatedTableGroup(this.tableGroupMap.get(parentPath))) {
                return tableGroup;
            }
            return null;
        }
        return tableGroup;
    }

    private TableGroup getCorrelatedTableGroup(TableGroup tableGroup) {
        if (tableGroup instanceof CorrelatedTableGroup) {
            return this.getCorrelatedTableGroup(((CorrelatedTableGroup)tableGroup).getCorrelatedTableGroup());
        }
        return tableGroup;
    }

    @Override
    public void registerTableGroup(NavigablePath navigablePath, TableGroup tableGroup) {
        Logger logger2 = SqlTreeCreationLogger.LOGGER;
        boolean debugEnabled = logger2.isDebugEnabled();
        if (debugEnabled) {
            logger2.debugf("Registration of TableGroup [%s] with identifierForTableGroup [%s] for NavigablePath [%s] ", (Object)tableGroup, (Object)tableGroup.getNavigablePath().getIdentifierForTableGroup(), (Object)navigablePath.getIdentifierForTableGroup());
        }
        TableGroup previous = this.tableGroupMap.put(navigablePath, tableGroup);
        if (debugEnabled && previous != null) {
            logger2.debugf("Registration of TableGroup [%s] for NavigablePath [%s] overrode previous registration : %s", (Object)tableGroup, (Object)navigablePath, (Object)previous);
        }
    }
}

