/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client.jaxrs.internal.proxy.extractors;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import org.jboss.resteasy.client.jaxrs.internal.proxy.extractors.ClientContext;
import org.jboss.resteasy.client.jaxrs.internal.proxy.extractors.ClientResponseProxy;
import org.jboss.resteasy.client.jaxrs.internal.proxy.extractors.EntityExtractor;
import org.jboss.resteasy.client.jaxrs.internal.proxy.extractors.EntityExtractorFactory;

public class ResponseObjectProxy<T>
implements EntityExtractor {
    private Class<T> returnType;
    private HashMap<Method, EntityExtractor<?>> methodHandlers;

    public ResponseObjectProxy(Method method, EntityExtractorFactory extractorFactory) {
        this.returnType = method.getReturnType();
        this.methodHandlers = new HashMap();
        for (Method interfaceMethod : this.returnType.getMethods()) {
            this.methodHandlers.put(interfaceMethod, extractorFactory.createExtractor(interfaceMethod));
        }
    }

    public Object extractEntity(ClientContext context, Object ... args) {
        ClassLoader clazzLoader;
        Class[] intfs = new Class[]{this.returnType};
        ClientResponseProxy clientProxy = new ClientResponseProxy(context, this.methodHandlers, this.returnType);
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            clazzLoader = this.returnType.getClassLoader();
            if (clazzLoader == null) {
                clazzLoader = Thread.currentThread().getContextClassLoader();
            }
        } else {
            clazzLoader = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    ClassLoader result = ResponseObjectProxy.this.returnType.getClassLoader();
                    if (result == null) {
                        result = Thread.currentThread().getContextClassLoader();
                    }
                    return result;
                }
            });
        }
        return Proxy.newProxyInstance(clazzLoader, intfs, (InvocationHandler)clientProxy);
    }
}

