/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.collection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.collections4.Unmodifiable;
import org.apache.commons.collections4.collection.AbstractCollectionTest;
import org.apache.commons.collections4.collection.UnmodifiableCollection;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class UnmodifiableCollectionTest<E>
extends AbstractCollectionTest<E> {
    @Override
    public String getCompatibilityVersion() {
        return "4";
    }

    @Override
    public boolean isAddSupported() {
        return false;
    }

    @Override
    public boolean isRemoveSupported() {
        return false;
    }

    @Override
    public Collection<E> makeConfirmedCollection() {
        return new ArrayList();
    }

    @Override
    public Collection<E> makeConfirmedFullCollection() {
        return new ArrayList(Arrays.asList(this.getFullElements()));
    }

    @Override
    public Collection<E> makeFullCollection() {
        ArrayList list = new ArrayList(Arrays.asList(this.getFullElements()));
        return UnmodifiableCollection.unmodifiableCollection(list);
    }

    @Override
    public Collection<E> makeObject() {
        return UnmodifiableCollection.unmodifiableCollection(new ArrayList());
    }

    @Test
    public void testDecorateFactory() {
        Collection<E> coll = this.makeFullCollection();
        Assertions.assertSame(coll, (Object)UnmodifiableCollection.unmodifiableCollection(coll));
        Assertions.assertThrows(NullPointerException.class, () -> UnmodifiableCollection.unmodifiableCollection(null));
    }

    @Test
    public void testUnmodifiable() {
        Assertions.assertTrue((boolean)(this.makeObject() instanceof Unmodifiable));
        Assertions.assertTrue((boolean)(this.makeFullCollection() instanceof Unmodifiable));
    }
}

