/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oidc.idp;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.cxf.jaxrs.utils.ExceptionUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.rs.security.jose.jwa.SignatureAlgorithm;
import org.apache.cxf.rs.security.jose.jws.JwsUtils;
import org.apache.cxf.rs.security.jose.jwt.JwtClaims;
import org.apache.cxf.rs.security.jose.jwt.JwtToken;
import org.apache.cxf.rs.security.oauth2.common.AbstractFormImplicitResponse;
import org.apache.cxf.rs.security.oauth2.common.Client;
import org.apache.cxf.rs.security.oauth2.common.OAuthError;
import org.apache.cxf.rs.security.oauth2.common.OAuthPermission;
import org.apache.cxf.rs.security.oauth2.common.OAuthRedirectionState;
import org.apache.cxf.rs.security.oauth2.common.ServerAccessToken;
import org.apache.cxf.rs.security.oauth2.common.UserSubject;
import org.apache.cxf.rs.security.oauth2.provider.OAuthJoseJwtProducer;
import org.apache.cxf.rs.security.oauth2.provider.OAuthServiceException;
import org.apache.cxf.rs.security.oauth2.services.ImplicitGrantService;
import org.apache.cxf.rs.security.oauth2.utils.OAuthUtils;
import org.apache.cxf.rs.security.oidc.common.IdToken;
import org.apache.cxf.rs.security.oidc.idp.FormIdTokenResponse;
import org.apache.cxf.rs.security.oidc.idp.IdTokenProvider;
import org.apache.cxf.rs.security.oidc.idp.OidcUserSubject;
import org.apache.cxf.rs.security.oidc.utils.OidcUtils;

public class OidcImplicitService
extends ImplicitGrantService {
    private OAuthJoseJwtProducer idTokenHandler;
    private IdTokenProvider idTokenProvider;

    public OidcImplicitService() {
        super(new HashSet<String>(Arrays.asList("id_token", "id_token token")));
    }

    protected OidcImplicitService(Set<String> supportedResponseTypes, String supportedGrantType) {
        super(supportedResponseTypes, supportedGrantType);
    }

    protected boolean canAccessTokenBeReturned(String responseType) {
        return "id_token token".equals(responseType);
    }

    protected Response startAuthorization(MultivaluedMap<String, String> params, UserSubject userSubject, Client client, String redirectUri) {
        if (params.getFirst((Object)"nonce") == null) {
            LOG.fine("A nonce is required for the Implicit flow");
            return this.createErrorResponse(params, redirectUri, "invalid_request");
        }
        List<String> promptValues = OidcUtils.getPromptValues(params);
        if (promptValues.size() > 1 && promptValues.contains("none")) {
            LOG.log(Level.FINE, "The prompt value {} is invalid", params.getFirst((Object)"prompt"));
            return this.createErrorResponse(params, redirectUri, "invalid_request");
        }
        return super.startAuthorization(params, userSubject, client, redirectUri);
    }

    protected boolean canAuthorizationBeSkipped(MultivaluedMap<String, String> params, Client client, UserSubject userSubject, List<String> requestedScope, List<OAuthPermission> permissions) {
        List<String> promptValues = OidcUtils.getPromptValues(params);
        if (promptValues.contains("consent")) {
            return false;
        }
        boolean preConfiguredConsentForScopes = super.canAuthorizationBeSkipped(params, client, userSubject, requestedScope, permissions);
        if (!preConfiguredConsentForScopes && promptValues.contains("none")) {
            LOG.log(Level.FINE, "Prompt 'none' request can not be met");
            throw new OAuthServiceException(new OAuthError("consent_required"));
        }
        return preConfiguredConsentForScopes;
    }

    public void setSkipAuthorizationWithOidcScope(boolean skipAuthorizationWithOidcScope) {
        super.setScopesRequiringNoConsent(Collections.singletonList("openid"));
    }

    protected StringBuilder prepareRedirectResponse(OAuthRedirectionState state, Client client, List<String> requestedScope, List<String> approvedScope, UserSubject userSubject, ServerAccessToken preAuthorizedToken) {
        if (this.canAccessTokenBeReturned(state.getResponseType())) {
            return super.prepareRedirectResponse(state, client, requestedScope, approvedScope, userSubject, preAuthorizedToken);
        }
        StringBuilder sb = this.getUriWithFragment(state.getRedirectUri());
        String idToken = this.getProcessedIdToken(state, userSubject, this.getApprovedScope(requestedScope, approvedScope));
        if (idToken != null) {
            sb.append("id_token").append('=').append(idToken);
        } else if (state.getResponseType().contains("id_token")) {
            LOG.warning("No IdToken available. Did you configure a IdTokenProvider implementation?");
            throw ExceptionUtils.toInternalServerErrorException(null, null);
        }
        this.finalizeResponse(sb, state);
        return sb;
    }

    protected AbstractFormImplicitResponse prepareFormResponse(OAuthRedirectionState state, Client client, List<String> requestedScope, List<String> approvedScope, UserSubject userSubject, ServerAccessToken preAuthorizedToken) {
        if (this.canAccessTokenBeReturned(state.getResponseType())) {
            return super.prepareFormResponse(state, client, requestedScope, approvedScope, userSubject, preAuthorizedToken);
        }
        String idToken = this.getProcessedIdToken(state, userSubject, this.getApprovedScope(requestedScope, approvedScope));
        if (idToken == null && state.getResponseType().contains("id_token")) {
            LOG.warning("No IdToken available. Did you configure a IdTokenProvider implementation?");
            throw ExceptionUtils.toInternalServerErrorException(null, null);
        }
        FormIdTokenResponse response = new FormIdTokenResponse();
        response.setIdToken(idToken);
        response.setResponseType(state.getResponseType());
        response.setRedirectUri(state.getRedirectUri());
        response.setState(state.getState());
        return response;
    }

    private String getProcessedIdToken(OAuthRedirectionState state, UserSubject subject, List<String> scopes) {
        if (subject.getProperties().containsKey("id_token")) {
            return (String)subject.getProperties().get("id_token");
        }
        if (this.idTokenProvider != null) {
            IdToken idToken = this.idTokenProvider.getIdToken(state.getClientId(), subject, scopes);
            return this.processIdToken(state, idToken);
        }
        if (subject instanceof OidcUserSubject) {
            OidcUserSubject sub = (OidcUserSubject)subject;
            IdToken idToken = new IdToken(sub.getIdToken());
            idToken.setAudience(state.getClientId());
            idToken.setAuthorizedParty(state.getClientId());
            return this.processIdToken(state, idToken);
        }
        return null;
    }

    protected OAuthRedirectionState recreateRedirectionStateFromParams(MultivaluedMap<String, String> params) {
        OAuthRedirectionState state = super.recreateRedirectionStateFromParams(params);
        OidcUtils.setStateClaimsProperty(state, params);
        return state;
    }

    protected String processIdToken(OAuthRedirectionState state, IdToken idToken) {
        OAuthJoseJwtProducer processor = this.idTokenHandler == null ? new OAuthJoseJwtProducer() : this.idTokenHandler;
        String code = (String)JAXRSUtils.getCurrentMessage().getExchange().get((Object)"code");
        if (code != null) {
            Properties props = JwsUtils.loadSignatureOutProperties((boolean)false);
            SignatureAlgorithm sigAlgo = processor.isSignWithClientSecret() ? OAuthUtils.getClientSecretSignatureAlgorithm((Properties)props) : JwsUtils.getSignatureAlgorithm((Properties)props, (SignatureAlgorithm)SignatureAlgorithm.RS256);
            idToken.setAuthorizationCodeHash(OidcUtils.calculateAuthorizationCodeHash(code, sigAlgo));
        }
        idToken.setNonce(state.getNonce());
        return processor.processJwt(new JwtToken((JwtClaims)idToken));
    }

    public void setIdTokenJoseHandler(OAuthJoseJwtProducer idTokenJoseHandler) {
        this.idTokenHandler = idTokenJoseHandler;
    }

    public void setIdTokenProvider(IdTokenProvider idTokenProvider) {
        this.idTokenProvider = idTokenProvider;
    }
}

