/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.api;

import io.undertow.servlet.api.TransportGuaranteeType;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class SecurityInfo<T extends SecurityInfo>
implements Cloneable {
    private volatile EmptyRoleSemantic emptyRoleSemantic = EmptyRoleSemantic.DENY;
    private final Set<String> rolesAllowed = new HashSet<String>();
    private volatile TransportGuaranteeType transportGuaranteeType = TransportGuaranteeType.NONE;

    public EmptyRoleSemantic getEmptyRoleSemantic() {
        return this.emptyRoleSemantic;
    }

    public T setEmptyRoleSemantic(EmptyRoleSemantic emptyRoleSemantic) {
        this.emptyRoleSemantic = emptyRoleSemantic;
        return (T)this;
    }

    public TransportGuaranteeType getTransportGuaranteeType() {
        return this.transportGuaranteeType;
    }

    public T setTransportGuaranteeType(TransportGuaranteeType transportGuaranteeType) {
        this.transportGuaranteeType = transportGuaranteeType;
        return (T)this;
    }

    public T addRoleAllowed(String role) {
        this.rolesAllowed.add(role);
        return (T)this;
    }

    public T addRolesAllowed(String ... roles) {
        this.rolesAllowed.addAll(Arrays.asList(roles));
        return (T)this;
    }

    public T addRolesAllowed(Collection<String> roles) {
        this.rolesAllowed.addAll(roles);
        return (T)this;
    }

    public Set<String> getRolesAllowed() {
        return new HashSet<String>(this.rolesAllowed);
    }

    public T clone() {
        T info = this.createInstance();
        ((SecurityInfo)info).emptyRoleSemantic = this.emptyRoleSemantic;
        ((SecurityInfo)info).transportGuaranteeType = this.transportGuaranteeType;
        ((SecurityInfo)info).rolesAllowed.addAll(this.rolesAllowed);
        return info;
    }

    protected T createInstance() {
        return (T)new SecurityInfo<T>();
    }

    public static enum EmptyRoleSemantic {
        PERMIT,
        DENY,
        AUTHENTICATE;

    }
}

