/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.core.impl;

import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.directory.fortress.core.FinderException;
import org.apache.directory.fortress.core.SecurityException;
import org.apache.directory.fortress.core.ValidationException;
import org.apache.directory.fortress.core.impl.AdminRoleP;
import org.apache.directory.fortress.core.impl.OrgUnitP;
import org.apache.directory.fortress.core.impl.PermDAO;
import org.apache.directory.fortress.core.impl.RoleP;
import org.apache.directory.fortress.core.impl.UserP;
import org.apache.directory.fortress.core.model.AdminRole;
import org.apache.directory.fortress.core.model.OrgUnit;
import org.apache.directory.fortress.core.model.PermObj;
import org.apache.directory.fortress.core.model.Permission;
import org.apache.directory.fortress.core.model.PermissionAttribute;
import org.apache.directory.fortress.core.model.PermissionAttributeSet;
import org.apache.directory.fortress.core.model.Role;
import org.apache.directory.fortress.core.model.Session;
import org.apache.directory.fortress.core.model.User;
import org.apache.directory.fortress.core.util.VUtil;

final class PermP {
    private PermDAO pDao = new PermDAO();
    private OrgUnitP orgUnitP = new OrgUnitP();

    PermP() {
    }

    boolean checkPermission(Session session, Permission permission) throws SecurityException {
        return this.pDao.checkPermission(session, permission);
    }

    List<Permission> search(Permission permission) throws SecurityException {
        return this.pDao.findPermissions(permission);
    }

    List<Permission> searchOperations(PermObj permObj) throws SecurityException {
        return this.pDao.findPermissionOperations(permObj);
    }

    List<Permission> searchAny(Permission permission) throws SecurityException {
        return this.pDao.findAnyPermissions(permission);
    }

    List<PermObj> search(PermObj permObj) throws SecurityException {
        return this.pDao.findPermissions(permObj);
    }

    List<PermObj> search(OrgUnit ou, boolean limitSize) throws SecurityException {
        return this.pDao.findPermissions(ou, limitSize);
    }

    List<Permission> search(Role role, boolean noInheritance) throws SecurityException {
        return this.pDao.findPermissions(role, noInheritance);
    }

    List<Permission> search(Role role) throws SecurityException {
        return this.search(role, false);
    }

    List<Permission> search(User user) throws SecurityException {
        return this.pDao.findPermissions(user);
    }

    void remove(User user) throws SecurityException {
        try {
            List<Permission> list = this.pDao.findUserPermissions(user);
            for (Permission perm : list) {
                this.revoke(perm, user);
            }
        }
        catch (FinderException fe) {
            String error = "remove userId [" + user.getUserId() + "] caught FinderException=" + fe;
            throw new SecurityException(3022, error, fe);
        }
    }

    void remove(Role role) throws SecurityException {
        try {
            List<Permission> list = this.search(role);
            for (Permission perm : list) {
                this.revoke(perm, role);
            }
        }
        catch (FinderException fe) {
            String error = "remove role [" + role.getName() + "] caught FinderException=" + fe;
            throw new SecurityException(3023, error, fe);
        }
    }

    void remove(AdminRole role) throws SecurityException {
        try {
            List<Permission> list = this.search(role);
            for (Permission perm : list) {
                perm.setAdmin(true);
                this.revoke(perm, role);
            }
        }
        catch (FinderException fe) {
            String error = "remove admin role [" + role.getName() + "] caught FinderException=" + fe;
            throw new SecurityException(3024, error, fe);
        }
    }

    List<Permission> search(Session session) throws SecurityException {
        return this.search(session, false);
    }

    List<Permission> search(Session session, boolean isAdmin) throws SecurityException {
        return this.pDao.findPermissions(session, isAdmin);
    }

    Permission read(Permission permission) throws SecurityException {
        return this.pDao.getPerm(permission);
    }

    PermObj read(PermObj permObj) throws SecurityException {
        return this.pDao.getPerm(permObj);
    }

    PermissionAttributeSet read(PermissionAttributeSet permAttributeSet) throws SecurityException {
        return this.pDao.getPermAttributeSet(permAttributeSet);
    }

    PermObj add(PermObj entity) throws SecurityException {
        this.validate(entity, false);
        return this.pDao.createObject(entity);
    }

    Permission add(Permission entity) throws SecurityException {
        this.validate(entity, false);
        return this.pDao.createOperation(entity);
    }

    PermissionAttributeSet add(PermissionAttributeSet entity) throws SecurityException {
        this.validate(entity);
        return this.pDao.createPermissionAttributeSet(entity);
    }

    PermissionAttribute add(PermissionAttribute entity, String paSetName) throws SecurityException {
        this.validate(entity);
        return this.pDao.createPermissionAttribute(entity, paSetName);
    }

    void delete(PermissionAttribute entity, String paSetName) throws SecurityException {
        this.validate(entity);
        this.pDao.deletePermissionAttribute(entity, paSetName);
    }

    void update(PermissionAttribute entity, String paSetName, boolean replaceValidValues) throws SecurityException {
        this.validate(entity);
        this.pDao.updatePermissionAttribute(entity, paSetName, replaceValidValues);
    }

    PermObj update(PermObj entity) throws SecurityException {
        this.update(entity, true);
        return entity;
    }

    private PermObj update(PermObj entity, boolean validate) throws SecurityException {
        if (validate) {
            this.validate(entity, true);
        }
        return this.pDao.updateObj(entity);
    }

    Permission update(Permission entity) throws SecurityException {
        this.update(entity, true);
        return entity;
    }

    private Permission update(Permission entity, boolean validate) throws SecurityException {
        if (validate) {
            this.validate(entity, true);
        }
        return this.pDao.updateOperation(entity);
    }

    void delete(PermObj entity) throws SecurityException {
        this.pDao.deleteObj(entity);
    }

    void delete(Permission entity) throws SecurityException {
        this.pDao.deleteOperation(entity);
    }

    void delete(PermissionAttributeSet entity) throws SecurityException {
        this.pDao.deleteAttributeSet(entity);
    }

    void grant(Permission pOp, Role role) throws SecurityException {
        this.pDao.grant(pOp, role);
    }

    void revoke(Permission pOp, Role role) throws SecurityException {
        this.pDao.revoke(pOp, role);
    }

    void grant(Permission pOp, User user) throws SecurityException {
        this.pDao.grant(pOp, user);
    }

    void revoke(Permission pOp, User user) throws SecurityException {
        this.pDao.revoke(pOp, user);
    }

    void validate(PermObj pObj, boolean isUpdate) throws ValidationException {
        if (!isUpdate) {
            VUtil.orgUnit(pObj.getOu());
            OrgUnit ou = new OrgUnit(pObj.getOu(), OrgUnit.Type.PERM);
            ou.setContextId(pObj.getContextId());
            if (!this.orgUnitP.isValid(ou)) {
                String error = "validate detected invalid orgUnit name [" + pObj.getOu() + "] for object name [" + pObj.getObjName() + "]";
                throw new ValidationException(3025, error);
            }
            if (StringUtils.isNotEmpty((CharSequence)pObj.getObjName())) {
                VUtil.description(pObj.getObjName());
            }
            if (StringUtils.isNotEmpty((CharSequence)pObj.getOu())) {
                VUtil.orgUnit(pObj.getOu());
            }
            if (StringUtils.isNotEmpty((CharSequence)pObj.getDescription())) {
                VUtil.description(pObj.getDescription());
            }
        } else {
            if (StringUtils.isNotEmpty((CharSequence)pObj.getOu())) {
                VUtil.orgUnit(pObj.getOu());
                OrgUnit ou = new OrgUnit(pObj.getOu(), OrgUnit.Type.PERM);
                ou.setContextId(pObj.getContextId());
                if (!this.orgUnitP.isValid(ou)) {
                    String error = "validate detected invalid orgUnit name [" + pObj.getOu() + "] for object name [" + pObj.getObjName() + "]";
                    throw new ValidationException(3025, error);
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)pObj.getDescription())) {
                VUtil.description(pObj.getDescription());
            }
        }
    }

    private void validate(Permission pOp, boolean isUpdate) throws SecurityException {
        if (!isUpdate && pOp.getOpName() != null && pOp.getOpName().length() > 0) {
            VUtil.description(pOp.getOpName());
        }
        if (StringUtils.isNotEmpty((CharSequence)pOp.getType())) {
            VUtil.description(pOp.getType());
        }
        if (StringUtils.isNotEmpty((CharSequence)pOp.getDescription())) {
            VUtil.description(pOp.getDescription());
        }
        if (CollectionUtils.isNotEmpty(pOp.getRoles())) {
            Set<String> roles = pOp.getRoles();
            if (pOp.isAdmin()) {
                AdminRoleP arp = new AdminRoleP();
                for (String roleNm : roles) {
                    AdminRole adminRole = new AdminRole(roleNm);
                    adminRole.setContextId(pOp.getContextId());
                    arp.read(adminRole);
                }
            } else {
                RoleP rp = new RoleP();
                for (String roleNm : roles) {
                    Role role = new Role(roleNm);
                    role.setContextId(pOp.getContextId());
                    rp.readConstraints(role);
                }
            }
        }
        if (CollectionUtils.isNotEmpty(pOp.getUsers())) {
            Set<String> users = pOp.getUsers();
            UserP up = new UserP();
            for (String userId : users) {
                User user = new User(userId);
                user.setContextId(pOp.getContextId());
                up.read(user, false);
            }
        }
        if (CollectionUtils.isNotEmpty(pOp.getPaSets())) {
            for (String paSetName : pOp.getPaSets()) {
                this.validatePaSet(paSetName, pOp.getContextId());
            }
        }
    }

    void validatePaSet(String paSetName, String contextId) throws ValidationException {
        try {
            PermissionAttributeSet paSet = new PermissionAttributeSet(paSetName);
            paSet.setContextId(contextId);
            this.read(paSet);
            VUtil.safeText(paSetName, 180);
        }
        catch (SecurityException e) {
            String error = "validatePaSet - paSetName not found with name [" + paSetName + "] caught SecurityException=" + e;
            throw new ValidationException(3035, error);
        }
    }

    private void validate(PermissionAttributeSet paSet) throws SecurityException {
        if (StringUtils.isNotEmpty((CharSequence)paSet.getType())) {
            VUtil.description(paSet.getType());
        }
        if (StringUtils.isNotEmpty((CharSequence)paSet.getDescription())) {
            VUtil.description(paSet.getDescription());
        }
    }

    private void validate(PermissionAttribute pa) throws SecurityException {
        if (StringUtils.isNotEmpty((CharSequence)pa.getAttributeName())) {
            VUtil.description(pa.getAttributeName());
        }
        if (StringUtils.isNotEmpty((CharSequence)pa.getDataType())) {
            VUtil.description(pa.getDataType());
        }
        if (StringUtils.isNotEmpty((CharSequence)pa.getDefaultOperator())) {
            VUtil.description(pa.getDefaultOperator());
        }
        if (StringUtils.isNotEmpty((CharSequence)pa.getDefaultStrategy())) {
            VUtil.description(pa.getDefaultStrategy());
        }
        if (StringUtils.isNotEmpty((CharSequence)pa.getDefaultValue())) {
            VUtil.description(pa.getDefaultValue());
        }
        if (StringUtils.isNotEmpty((CharSequence)pa.getDescription())) {
            VUtil.description(pa.getDescription());
        }
    }
}

