/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.view.wrappers;

import org.apache.directory.studio.schemaeditor.view.wrappers.AbstractTreeNode;
import org.apache.directory.studio.schemaeditor.view.wrappers.Messages;
import org.apache.directory.studio.schemaeditor.view.wrappers.TreeNode;
import org.eclipse.osgi.util.NLS;

public class Folder
extends AbstractTreeNode {
    private FolderType type = FolderType.NONE;
    private String name = "";

    public Folder(FolderType type, TreeNode parent) {
        super(parent);
        this.type = type;
        switch (type) {
            case ATTRIBUTE_TYPE: {
                this.name = Messages.getString("Folder.AttributeTypes");
                break;
            }
            case OBJECT_CLASS: {
                this.name = Messages.getString("Folder.ObjectClasses");
                break;
            }
            case ERROR: {
                this.name = Messages.getString("Folder.Errors");
                break;
            }
            case WARNING: {
                this.name = Messages.getString("Folder.Warnings");
                break;
            }
        }
    }

    public Folder(FolderType type, String name, TreeNode parent) {
        super(parent);
        this.type = type;
        this.name = name;
    }

    public FolderType getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof Folder) {
            Folder folder = (Folder)obj;
            if (this.getParent() != null && !this.getParent().equals(folder.getParent())) {
                return false;
            }
            if (!this.getType().equals((Object)folder.getType())) {
                return false;
            }
            return this.getName() == null || this.getName().equals(folder.getName());
        }
        return false;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        if (this.name != null) {
            result = 37 * result + this.name.hashCode();
        }
        if (this.type != null) {
            result = 37 * result + this.type.hashCode();
        }
        return result;
    }

    public String toString() {
        return NLS.bind((String)Messages.getString("Folder.Folder"), (Object[])new Object[]{this.type, this.fParent});
    }

    public static enum FolderType {
        NONE,
        ATTRIBUTE_TYPE,
        OBJECT_CLASS,
        ERROR,
        WARNING;

    }
}

