/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.valueeditors.address;

import org.apache.directory.studio.ldapbrowser.core.BrowserCoreConstants;
import org.apache.directory.studio.valueeditors.ValueEditorsActivator;
import org.apache.directory.studio.valueeditors.address.Messages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AddressDialog
extends Dialog {
    private String initialAddress;
    private String returnAddress;
    private Text text;

    public AddressDialog(Shell parentShell, String initialAddress) {
        super(parentShell);
        super.setShellStyle(super.getShellStyle() | 0x10);
        this.initialAddress = initialAddress;
        this.returnAddress = null;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.getString("AddressDialog.AddressEditor"));
        shell.setImage(ValueEditorsActivator.getDefault().getImage("resources/icons/addresseditor.gif"));
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void okPressed() {
        this.returnAddress = this.text.getText();
        this.returnAddress = this.returnAddress.replaceAll("\n", "\\$");
        this.returnAddress = this.returnAddress.replaceAll("\r", "\\$");
        this.returnAddress = this.returnAddress.replaceAll("\\$\\$", "\\$");
        super.okPressed();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridData gd = new GridData(1808);
        composite.setLayoutData((Object)gd);
        this.text = new Text(composite, 2818);
        this.text.setText(this.initialAddress.replaceAll("\\$", BrowserCoreConstants.LINE_SEPARATOR));
        gd = new GridData(1808);
        gd.widthHint = this.convertHorizontalDLUsToPixels(300);
        gd.heightHint = this.convertHorizontalDLUsToPixels(150);
        this.text.setLayoutData((Object)gd);
        AddressDialog.applyDialogFont((Control)composite);
        return composite;
    }

    public String getAddress() {
        return this.returnAddress;
    }
}

