/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.examples;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.helix.HelixAdmin;
import org.apache.helix.HelixManager;
import org.apache.helix.HelixManagerFactory;
import org.apache.helix.InstanceType;
import org.apache.helix.controller.HelixControllerMain;
import org.apache.helix.examples.LeaderStandbyStateModelFactory;
import org.apache.helix.manager.zk.ZKHelixAdmin;
import org.apache.helix.model.ExternalView;
import org.apache.helix.model.InstanceConfig;
import org.apache.helix.model.StateModelDefinition;
import org.apache.helix.participant.StateMachineEngine;
import org.apache.helix.zookeeper.zkclient.IDefaultNameSpace;
import org.apache.helix.zookeeper.zkclient.ZkClient;
import org.apache.helix.zookeeper.zkclient.ZkServer;

public class Quickstart {
    private static final String ZK_ADDRESS = "localhost:2199";
    private static final String CLUSTER_NAME = "HELIX_QUICKSTART";
    private static final String RESOURCE_NAME = "MyResource";
    private static final int NUM_PARTITIONS = 6;
    private static final int NUM_REPLICAS = 2;
    private static final String STATE_MODEL_NAME = "MyStateModel";
    private static int NUM_NODES = 2;
    private static final String STANDBY = "STANDBY";
    private static final String OFFLINE = "OFFLINE";
    private static final String LEADER = "LEADER";
    private static final String DROPPED = "DROPPED";
    private static final List<InstanceConfig> INSTANCE_CONFIG_LIST = new ArrayList<InstanceConfig>();
    private static final List<MyProcess> PROCESS_LIST = new ArrayList<MyProcess>();
    private static HelixAdmin admin;

    public static void setup() {
        admin = new ZKHelixAdmin(ZK_ADDRESS);
        Quickstart.echo("Creating cluster: HELIX_QUICKSTART");
        admin.addCluster(CLUSTER_NAME, true);
        Quickstart.echo("Adding " + NUM_NODES + " participants to the cluster");
        for (int i = 0; i < NUM_NODES; ++i) {
            admin.addInstance(CLUSTER_NAME, INSTANCE_CONFIG_LIST.get(i));
            Quickstart.echo("\t Added participant: " + INSTANCE_CONFIG_LIST.get(i).getInstanceName());
        }
        StateModelDefinition myStateModel = Quickstart.defineStateModel();
        Quickstart.echo("Configuring StateModel: MyStateModel  with 1 Leader and 1 Standby");
        admin.addStateModelDef(CLUSTER_NAME, STATE_MODEL_NAME, myStateModel);
        Quickstart.echo("Adding a resource MyResource: with 6 partitions and 2 replicas");
        admin.addResource(CLUSTER_NAME, RESOURCE_NAME, 6, STATE_MODEL_NAME, "AUTO");
        admin.rebalance(CLUSTER_NAME, RESOURCE_NAME, 2);
    }

    private static StateModelDefinition defineStateModel() {
        StateModelDefinition.Builder builder = new StateModelDefinition.Builder(STATE_MODEL_NAME);
        builder.addState(LEADER, 1);
        builder.addState(STANDBY, 2);
        builder.addState(OFFLINE);
        builder.addState(DROPPED);
        builder.initialState(OFFLINE);
        builder.addTransition(OFFLINE, STANDBY);
        builder.addTransition(STANDBY, OFFLINE);
        builder.addTransition(STANDBY, LEADER);
        builder.addTransition(LEADER, STANDBY);
        builder.addTransition(OFFLINE, DROPPED);
        builder.upperBound(LEADER, 1);
        builder.dynamicUpperBound(STANDBY, "R");
        StateModelDefinition statemodelDefinition = builder.build();
        return statemodelDefinition;
    }

    public static void startController() {
        Quickstart.echo("Starting Helix Controller");
        HelixControllerMain.startHelixController(ZK_ADDRESS, CLUSTER_NAME, "localhost_9100", "STANDALONE");
    }

    public static void startNodes() throws Exception {
        Quickstart.echo("Starting Participants");
        for (int i = 0; i < NUM_NODES; ++i) {
            MyProcess process = new MyProcess(INSTANCE_CONFIG_LIST.get(i).getId());
            PROCESS_LIST.add(process);
            process.start();
            Quickstart.echo("\t Started Participant: " + INSTANCE_CONFIG_LIST.get(i).getId());
        }
    }

    public static void startZookeeper() {
        Quickstart.echo("STARTING Zookeeper at localhost:2199");
        IDefaultNameSpace defaultNameSpace = new IDefaultNameSpace(){

            @Override
            public void createDefaultNameSpace(ZkClient zkClient) {
            }
        };
        new File("/tmp/helix-quickstart").mkdirs();
        ZkServer server = new ZkServer("/tmp/helix-quickstart/dataDir", "/tmp/helix-quickstart/logDir", defaultNameSpace, 2199);
        server.start();
    }

    public static void echo(Object obj) {
        System.out.println(obj);
    }

    public static void main(String[] args) throws Exception {
        Quickstart.startZookeeper();
        Quickstart.setup();
        Quickstart.startNodes();
        Quickstart.startController();
        Thread.sleep(5000L);
        Quickstart.printState("After starting 2 nodes");
        Quickstart.addNode();
        Thread.sleep(5000L);
        Quickstart.printState("After adding a third node");
        Quickstart.stopNode();
        Thread.sleep(5000L);
        Quickstart.printState("After the 3rd node stops/crashes");
        Thread.currentThread().join();
        System.exit(0);
    }

    private static void addNode() throws Exception {
        int port = 12000 + ++NUM_NODES - 1;
        InstanceConfig instanceConfig = new InstanceConfig("localhost_" + port);
        instanceConfig.setHostName("localhost");
        instanceConfig.setPort("" + port);
        instanceConfig.setInstanceEnabled(true);
        Quickstart.echo("ADDING NEW NODE :" + instanceConfig.getInstanceName() + ". Partitions will move from old nodes to the new node.");
        admin.addInstance(CLUSTER_NAME, instanceConfig);
        INSTANCE_CONFIG_LIST.add(instanceConfig);
        MyProcess process = new MyProcess(instanceConfig.getInstanceName());
        PROCESS_LIST.add(process);
        admin.rebalance(CLUSTER_NAME, RESOURCE_NAME, 3);
        process.start();
    }

    private static void stopNode() {
        int nodeId = NUM_NODES - 1;
        Quickstart.echo("STOPPING " + INSTANCE_CONFIG_LIST.get(nodeId).getInstanceName() + ". Leadership will be transferred to the remaining nodes");
        PROCESS_LIST.get(nodeId).stop();
    }

    private static void printState(String msg) {
        System.out.println("CLUSTER STATE: " + msg);
        ExternalView resourceExternalView = admin.getResourceExternalView(CLUSTER_NAME, RESOURCE_NAME);
        TreeSet<String> sortedSet = new TreeSet<String>(resourceExternalView.getPartitionSet());
        StringBuilder sb = new StringBuilder("\t\t");
        for (int i = 0; i < NUM_NODES; ++i) {
            sb.append(INSTANCE_CONFIG_LIST.get(i).getInstanceName()).append("\t");
        }
        System.out.println(sb);
        for (String partitionName : sortedSet) {
            sb.delete(0, sb.length() - 1);
            sb.append(partitionName).append("\t");
            for (int i = 0; i < NUM_NODES; ++i) {
                Map<String, String> stateMap = resourceExternalView.getStateMap(partitionName);
                if (stateMap != null && stateMap.containsKey(INSTANCE_CONFIG_LIST.get(i).getInstanceName())) {
                    sb.append(stateMap.get(INSTANCE_CONFIG_LIST.get(i).getInstanceName()).charAt(0)).append("\t\t");
                    continue;
                }
                sb.append("-").append("\t\t");
            }
            System.out.println(sb);
        }
        System.out.println("###################################################################");
    }

    static {
        for (int i = 0; i < NUM_NODES; ++i) {
            int port = 12000 + i;
            InstanceConfig instanceConfig = new InstanceConfig("localhost_" + port);
            instanceConfig.setHostName("localhost");
            instanceConfig.setPort("" + port);
            instanceConfig.setInstanceEnabled(true);
            INSTANCE_CONFIG_LIST.add(instanceConfig);
        }
    }

    static final class MyProcess {
        private final String instanceName;
        private HelixManager manager;

        public MyProcess(String instanceName) {
            this.instanceName = instanceName;
        }

        public void start() throws Exception {
            this.manager = HelixManagerFactory.getZKHelixManager(Quickstart.CLUSTER_NAME, this.instanceName, InstanceType.PARTICIPANT, Quickstart.ZK_ADDRESS);
            LeaderStandbyStateModelFactory stateModelFactory = new LeaderStandbyStateModelFactory(this.instanceName);
            StateMachineEngine stateMach = this.manager.getStateMachineEngine();
            stateMach.registerStateModelFactory(Quickstart.STATE_MODEL_NAME, stateModelFactory);
            this.manager.connect();
        }

        public void stop() {
            this.manager.disconnect();
        }
    }
}

