/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.spectator;

import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.helix.HelixConstants;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixException;
import org.apache.helix.PropertyType;
import org.apache.helix.common.caches.BasicClusterDataCache;
import org.apache.helix.common.caches.CurrentStateCache;
import org.apache.helix.common.caches.CurrentStateSnapshot;
import org.apache.helix.common.caches.CustomizedViewCache;
import org.apache.helix.common.caches.TargetExternalViewCache;
import org.apache.helix.model.CurrentState;
import org.apache.helix.model.CustomizedView;
import org.apache.helix.model.ExternalView;
import org.apache.helix.model.LiveInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RoutingDataCache
extends BasicClusterDataCache {
    private static Logger LOG = LoggerFactory.getLogger((String)RoutingDataCache.class.getName());
    private final Map<PropertyType, List<String>> _sourceDataTypeMap;
    private CurrentStateCache _currentStateCache;
    private Map<String, CustomizedViewCache> _customizedViewCaches;
    private TargetExternalViewCache _targetExternalViewCache;

    public RoutingDataCache(String clusterName, PropertyType sourceDataType) {
        this(clusterName, (Map<PropertyType, List<String>>)ImmutableMap.of((Object)((Object)sourceDataType), Collections.emptyList()));
    }

    public RoutingDataCache(String clusterName, Map<PropertyType, List<String>> sourceDataTypeMap) {
        super(clusterName);
        this._sourceDataTypeMap = sourceDataTypeMap;
        this._currentStateCache = new CurrentStateCache(clusterName);
        this._customizedViewCaches = new HashMap<String, CustomizedViewCache>();
        sourceDataTypeMap.getOrDefault((Object)PropertyType.CUSTOMIZEDVIEW, Collections.emptyList()).forEach(customizedStateType -> this._customizedViewCaches.put((String)customizedStateType, new CustomizedViewCache(clusterName, (String)customizedStateType)));
        this._targetExternalViewCache = new TargetExternalViewCache(clusterName);
        this.requireFullRefresh();
    }

    @Override
    public synchronized void refresh(HelixDataAccessor accessor) {
        LOG.info("START: RoutingDataCache.refresh() for cluster " + this._clusterName);
        long startTime = System.currentTimeMillis();
        super.refresh(accessor);
        for (PropertyType propertyType : this._sourceDataTypeMap.keySet()) {
            long start = System.currentTimeMillis();
            switch (propertyType) {
                case TARGETEXTERNALVIEW: {
                    if (!((Boolean)this._propertyDataChangedMap.get((Object)HelixConstants.ChangeType.TARGET_EXTERNAL_VIEW)).booleanValue()) break;
                    this._propertyDataChangedMap.put(HelixConstants.ChangeType.TARGET_EXTERNAL_VIEW, false);
                    this._targetExternalViewCache.refresh(accessor);
                    LOG.info("Reload " + this._targetExternalViewCache.getExternalViewMap().keySet().size() + " TargetExternalViews. Takes " + (System.currentTimeMillis() - start) + " ms");
                    break;
                }
                case CURRENTSTATES: {
                    if (!((Boolean)this._propertyDataChangedMap.get((Object)HelixConstants.ChangeType.CURRENT_STATE)).booleanValue()) break;
                    this._propertyDataChangedMap.put(HelixConstants.ChangeType.CURRENT_STATE, false);
                    this._liveInstancePropertyCache.refresh(accessor);
                    Map<String, LiveInstance> liveInstanceMap = this.getLiveInstances();
                    this._currentStateCache.refresh(accessor, liveInstanceMap);
                    LOG.info("Reload CurrentStates. Takes " + (System.currentTimeMillis() - start) + " ms");
                    break;
                }
                case CUSTOMIZEDVIEW: {
                    if (((Boolean)this._propertyDataChangedMap.get((Object)HelixConstants.ChangeType.CUSTOMIZED_VIEW)).booleanValue()) {
                        for (String customizedStateType : this._sourceDataTypeMap.get((Object)PropertyType.CUSTOMIZEDVIEW)) {
                            this._customizedViewCaches.get(customizedStateType).refresh(accessor);
                        }
                        LOG.info("Reload CustomizedView for types " + this._sourceDataTypeMap.get((Object)PropertyType.CUSTOMIZEDVIEW) + " Takes " + (System.currentTimeMillis() - start) + " ms");
                    }
                    this._propertyDataChangedMap.put(HelixConstants.ChangeType.CUSTOMIZED_VIEW, false);
                    break;
                }
            }
        }
        long endTime = System.currentTimeMillis();
        LOG.info("END: RoutingDataCache.refresh() for cluster " + this._clusterName + ", took " + (endTime - startTime) + " ms");
        LOG.debug("CurrentStates: {}", (Object)this._currentStateCache);
        LOG.debug("TargetExternalViews: {}", this._targetExternalViewCache.getExternalViewMap());
        if (LOG.isDebugEnabled()) {
            for (String customizedStateType : this._sourceDataTypeMap.getOrDefault((Object)PropertyType.CUSTOMIZEDVIEW, Collections.emptyList())) {
                LOG.debug("CustomizedViews customizedStateType: {} {}", (Object)customizedStateType, this._customizedViewCaches.get(customizedStateType).getCustomizedViewMap());
            }
        }
    }

    public Map<String, ExternalView> getTargetExternalViews() {
        return this._targetExternalViewCache.getExternalViewMap();
    }

    public Map<String, CustomizedView> getCustomizedView(String customizedStateType) {
        if (this._customizedViewCaches.containsKey(customizedStateType)) {
            return this._customizedViewCaches.get(customizedStateType).getCustomizedViewMap();
        }
        throw new HelixException(String.format("customizedStateType %s does not exist in customizedViewCaches.", customizedStateType));
    }

    public Map<String, Map<String, Map<String, CurrentState>>> getCurrentStatesMap() {
        return this._currentStateCache.getParticipantStatesMap();
    }

    public CurrentStateSnapshot getCurrentStateSnapshot() {
        return this._currentStateCache.getSnapshot();
    }
}

