/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner.changestreams.dao;

import com.google.api.gax.longrunning.OperationFuture;
import com.google.cloud.spanner.DatabaseAdminClient;
import com.google.cloud.spanner.Dialect;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.dao.PartitionMetadataTableNames;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class PartitionMetadataAdminDao {
    public static final @UnknownKeyFor @NonNull @Initialized String COLUMN_PARTITION_TOKEN = "PartitionToken";
    public static final @UnknownKeyFor @NonNull @Initialized String COLUMN_PARENT_TOKENS = "ParentTokens";
    public static final @UnknownKeyFor @NonNull @Initialized String COLUMN_START_TIMESTAMP = "StartTimestamp";
    public static final @UnknownKeyFor @NonNull @Initialized String COLUMN_END_TIMESTAMP = "EndTimestamp";
    public static final @UnknownKeyFor @NonNull @Initialized String COLUMN_HEARTBEAT_MILLIS = "HeartbeatMillis";
    public static final @UnknownKeyFor @NonNull @Initialized String COLUMN_STATE = "State";
    public static final @UnknownKeyFor @NonNull @Initialized String COLUMN_WATERMARK = "Watermark";
    public static final @UnknownKeyFor @NonNull @Initialized String COLUMN_CREATED_AT = "CreatedAt";
    public static final @UnknownKeyFor @NonNull @Initialized String COLUMN_SCHEDULED_AT = "ScheduledAt";
    public static final @UnknownKeyFor @NonNull @Initialized String COLUMN_RUNNING_AT = "RunningAt";
    public static final @UnknownKeyFor @NonNull @Initialized String COLUMN_FINISHED_AT = "FinishedAt";
    private static final @UnknownKeyFor @NonNull @Initialized int TIMEOUT_MINUTES = 10;
    private static final @UnknownKeyFor @NonNull @Initialized int TTL_AFTER_PARTITION_FINISHED_DAYS = 1;
    private final @UnknownKeyFor @NonNull @Initialized DatabaseAdminClient databaseAdminClient;
    private final @UnknownKeyFor @NonNull @Initialized String instanceId;
    private final @UnknownKeyFor @NonNull @Initialized String databaseId;
    private final @UnknownKeyFor @NonNull @Initialized PartitionMetadataTableNames names;
    private final @UnknownKeyFor @NonNull @Initialized Dialect dialect;

    PartitionMetadataAdminDao(@UnknownKeyFor @NonNull @Initialized DatabaseAdminClient databaseAdminClient, @UnknownKeyFor @NonNull @Initialized String instanceId, @UnknownKeyFor @NonNull @Initialized String databaseId, @UnknownKeyFor @NonNull @Initialized PartitionMetadataTableNames names, @UnknownKeyFor @NonNull @Initialized Dialect dialect) {
        this.databaseAdminClient = databaseAdminClient;
        this.instanceId = instanceId;
        this.databaseId = databaseId;
        this.names = names;
        this.dialect = dialect;
    }

    public void createPartitionMetadataTable() {
        ArrayList<String> ddl = new ArrayList<String>();
        if (this.isPostgres()) {
            ddl.add("CREATE TABLE IF NOT EXISTS \"" + this.names.getTableName() + "\"(\"" + COLUMN_PARTITION_TOKEN + "\" text NOT NULL,\"" + COLUMN_PARENT_TOKENS + "\" text[] NOT NULL,\"" + COLUMN_START_TIMESTAMP + "\" timestamptz NOT NULL,\"" + COLUMN_END_TIMESTAMP + "\" timestamptz NOT NULL,\"" + COLUMN_HEARTBEAT_MILLIS + "\" BIGINT NOT NULL,\"" + COLUMN_STATE + "\" text NOT NULL,\"" + COLUMN_WATERMARK + "\" timestamptz NOT NULL,\"" + COLUMN_CREATED_AT + "\" SPANNER.COMMIT_TIMESTAMP NOT NULL,\"" + COLUMN_SCHEDULED_AT + "\" SPANNER.COMMIT_TIMESTAMP,\"" + COLUMN_RUNNING_AT + "\" SPANNER.COMMIT_TIMESTAMP,\"" + COLUMN_FINISHED_AT + "\" SPANNER.COMMIT_TIMESTAMP, PRIMARY KEY (\"" + COLUMN_PARTITION_TOKEN + "\")) TTL INTERVAL '" + 1 + " days' ON \"" + COLUMN_FINISHED_AT + "\"");
            ddl.add("CREATE INDEX IF NOT EXISTS \"" + this.names.getWatermarkIndexName() + "\" on \"" + this.names.getTableName() + "\" (\"" + COLUMN_WATERMARK + "\") INCLUDE (\"" + COLUMN_STATE + "\")");
            ddl.add("CREATE INDEX IF NOT EXISTS \"" + this.names.getCreatedAtIndexName() + "\" ON \"" + this.names.getTableName() + "\" (\"" + COLUMN_CREATED_AT + "\",\"" + COLUMN_START_TIMESTAMP + "\")");
        } else {
            ddl.add("CREATE TABLE IF NOT EXISTS " + this.names.getTableName() + " (" + COLUMN_PARTITION_TOKEN + " STRING(MAX) NOT NULL," + COLUMN_PARENT_TOKENS + " ARRAY<STRING(MAX)> NOT NULL," + COLUMN_START_TIMESTAMP + " TIMESTAMP NOT NULL," + COLUMN_END_TIMESTAMP + " TIMESTAMP NOT NULL," + COLUMN_HEARTBEAT_MILLIS + " INT64 NOT NULL," + COLUMN_STATE + " STRING(MAX) NOT NULL," + COLUMN_WATERMARK + " TIMESTAMP NOT NULL," + COLUMN_CREATED_AT + " TIMESTAMP NOT NULL OPTIONS (allow_commit_timestamp=true)," + COLUMN_SCHEDULED_AT + " TIMESTAMP OPTIONS (allow_commit_timestamp=true)," + COLUMN_RUNNING_AT + " TIMESTAMP OPTIONS (allow_commit_timestamp=true)," + COLUMN_FINISHED_AT + " TIMESTAMP OPTIONS (allow_commit_timestamp=true),) PRIMARY KEY (" + COLUMN_PARTITION_TOKEN + "), ROW DELETION POLICY (OLDER_THAN(" + COLUMN_FINISHED_AT + ", INTERVAL " + 1 + " DAY))");
            ddl.add("CREATE INDEX IF NOT EXISTS " + this.names.getWatermarkIndexName() + " on " + this.names.getTableName() + " (" + COLUMN_WATERMARK + ") STORING (" + COLUMN_STATE + ")");
            ddl.add("CREATE INDEX IF NOT EXISTS " + this.names.getCreatedAtIndexName() + " ON " + this.names.getTableName() + " (" + COLUMN_CREATED_AT + "," + COLUMN_START_TIMESTAMP + ")");
        }
        OperationFuture op = this.databaseAdminClient.updateDatabaseDdl(this.instanceId, this.databaseId, ddl, null);
        try {
            op.get(10L, TimeUnit.MINUTES);
        }
        catch (ExecutionException | TimeoutException e) {
            if (e.getCause() != null) {
                throw (SpannerException)e.getCause();
            }
            throw SpannerExceptionFactory.asSpannerException((Throwable)e);
        }
        catch (InterruptedException e) {
            throw SpannerExceptionFactory.propagateInterrupt((InterruptedException)e);
        }
    }

    public void deletePartitionMetadataTable(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> indexes) {
        ArrayList<String> ddl = new ArrayList<String>();
        if (this.isPostgres()) {
            indexes.forEach(index -> ddl.add("DROP INDEX \"" + index + "\""));
            ddl.add("DROP TABLE \"" + this.names.getTableName() + "\"");
        } else {
            indexes.forEach(index -> ddl.add("DROP INDEX " + index));
            ddl.add("DROP TABLE " + this.names.getTableName());
        }
        OperationFuture op = this.databaseAdminClient.updateDatabaseDdl(this.instanceId, this.databaseId, ddl, null);
        try {
            op.get(10L, TimeUnit.MINUTES);
        }
        catch (ExecutionException | TimeoutException e) {
            if (e.getCause() != null) {
                throw (SpannerException)e.getCause();
            }
            throw SpannerExceptionFactory.asSpannerException((Throwable)e);
        }
        catch (InterruptedException e) {
            throw SpannerExceptionFactory.propagateInterrupt((InterruptedException)e);
        }
    }

    private @UnknownKeyFor @NonNull @Initialized boolean isPostgres() {
        return this.dialect == Dialect.POSTGRESQL;
    }
}

