/*
 * Decompiled with CFR 0.152.
 */
package com.trilead.ssh2.crypto.cipher;

import com.trilead.ssh2.crypto.cipher.BlockCipher;
import com.trilead.ssh2.crypto.cipher.CBCMode;
import com.trilead.ssh2.crypto.cipher.CTRMode;
import com.trilead.ssh2.crypto.cipher.DES;

public class DESede
extends DES {
    private int[] key1 = null;
    private int[] key2 = null;
    private int[] key3 = null;
    private boolean encrypt;

    @Override
    public void init(boolean encrypting, byte[] key, byte[] iv) {
        this.key1 = this.generateWorkingKey(encrypting, key, 0);
        this.key2 = this.generateWorkingKey(!encrypting, key, 8);
        this.key3 = this.generateWorkingKey(encrypting, key, 16);
        this.encrypt = encrypting;
    }

    @Override
    public String getAlgorithmName() {
        return "DESede";
    }

    @Override
    public void transformBlock(byte[] in, int inOff, byte[] out, int outOff) {
        if (this.key1 == null) {
            throw new IllegalStateException("DESede engine not initialised!");
        }
        if (this.encrypt) {
            this.desFunc(this.key1, in, inOff, out, outOff);
            this.desFunc(this.key2, out, outOff, out, outOff);
            this.desFunc(this.key3, out, outOff, out, outOff);
        } else {
            this.desFunc(this.key3, in, inOff, out, outOff);
            this.desFunc(this.key2, out, outOff, out, outOff);
            this.desFunc(this.key1, out, outOff, out, outOff);
        }
    }

    public static class CTR
    extends Wrapper {
        @Override
        public void init(boolean forEncryption, byte[] key, byte[] iv) throws IllegalArgumentException {
            DESede rawCipher = new DESede();
            rawCipher.init(true, key, iv);
            this.bc = new CTRMode(rawCipher, iv, forEncryption);
        }
    }

    public static class CBC
    extends Wrapper {
        @Override
        public void init(boolean forEncryption, byte[] key, byte[] iv) throws IllegalArgumentException {
            DESede rawCipher = new DESede();
            rawCipher.init(forEncryption, key, iv);
            this.bc = new CBCMode(rawCipher, iv, forEncryption);
        }
    }

    private static abstract class Wrapper
    implements BlockCipher {
        protected BlockCipher bc;

        private Wrapper() {
        }

        @Override
        public int getBlockSize() {
            return this.bc.getBlockSize();
        }

        @Override
        public void transformBlock(byte[] src, int srcoff, byte[] dst, int dstoff) {
            this.bc.transformBlock(src, srcoff, dst, dstoff);
        }
    }
}

