/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.Converter;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;

public class SCS5256Writer
extends OutputStreamWriter {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private static final byte[] CR = new byte[]{13};
    private static final byte[] LF = new byte[]{37};
    private static final byte[] NL = new byte[]{21};
    private static final byte[] FF = new byte[]{12};
    private static final byte[] SGEA = new byte[]{43, -56, 1};
    private static final byte[] SHF = new byte[]{43, -63, 2, 0};
    private static final byte[] SVF = new byte[]{43, -62, 2, 0};
    private static final byte[] AHPP = new byte[]{52, -64, 0};
    private static final byte[] AVPP = new byte[]{52, -60, 0};
    private static final byte[] RHPP = new byte[]{52, -56, 0};
    private static final byte[] RVPP = new byte[]{52, 76, 0};
    private OutputStream outPut;
    private Converter cvt;
    private byte[] buffer = new byte[300];
    private int dataLength = 0;
    private int horizontalFormat_ = -1;
    private int verticalFormat_ = -1;
    boolean pageStarted_ = false;

    public SCS5256Writer(OutputStream out) {
        super(out);
        this.outPut = out;
        this.cvt = new Converter();
    }

    public SCS5256Writer(OutputStream out, int ccsid) throws UnsupportedEncodingException {
        super(out);
        this.outPut = out;
        this.cvt = new Converter(ccsid);
    }

    public SCS5256Writer(OutputStream out, int ccsid, AS400 system) throws UnsupportedEncodingException {
        super(out);
        this.outPut = out;
        this.cvt = new Converter(ccsid, system);
    }

    public SCS5256Writer(OutputStream out, String encoding) throws UnsupportedEncodingException {
        super(out);
        this.outPut = out;
        this.cvt = new Converter(encoding);
    }

    public void absoluteHorizontalPosition(int column) throws IOException {
        byte[] cmd = AHPP;
        if (column < 0 || column > 255) {
            String arg = "Column (" + String.valueOf(column) + ")";
            throw new ExtendedIllegalArgumentException(arg, 2);
        }
        if (!this.pageStarted_) {
            this.initPage();
        }
        cmd[cmd.length - 1] = (byte)column;
        this.addToBuffer(cmd);
    }

    public void absoluteVerticalPosition(int line) throws IOException {
        byte[] cmd = AVPP;
        if (line < 0 || line > 255) {
            String arg = "Line (" + String.valueOf(line) + ")";
            throw new ExtendedIllegalArgumentException(arg, 2);
        }
        if (!this.pageStarted_) {
            this.initPage();
        }
        cmd[cmd.length - 1] = (byte)line;
        this.addToBuffer(cmd);
    }

    void addToBuffer(byte[] data) throws IOException {
        if (this.outPut == null) {
            throw new IOException("Stream closed");
        }
        int len = data.length;
        if (this.dataLength + len > this.buffer.length) {
            this.flush();
        }
        for (int i = 0; i < len; ++i) {
            this.buffer[this.dataLength] = data[i];
            ++this.dataLength;
        }
    }

    public void carriageReturn() throws IOException {
        this.addToBuffer(CR);
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.outPut.close();
        this.outPut = null;
        this.cvt = null;
    }

    public void endPage() throws IOException {
        this.addToBuffer(FF);
        this.pageStarted_ = false;
    }

    @Override
    public void flush() throws IOException {
        if (this.dataLength > 0) {
            if (this.outPut == null) {
                throw new IOException("Stream closed");
            }
            this.outPut.write(this.buffer, 0, this.dataLength);
            this.dataLength = 0;
        }
    }

    int getCcsid() {
        if (this.cvt == null) {
            return 0;
        }
        return this.cvt.getCcsid();
    }

    @Override
    public String getEncoding() {
        if (this.cvt == null) {
            return null;
        }
        return this.cvt.getEncoding();
    }

    void initPage() throws IOException {
        this.pageStarted_ = true;
        this.sendSGEA();
        if (this.horizontalFormat_ != -1) {
            this.setHorizontalFormat(this.horizontalFormat_);
        }
        if (this.verticalFormat_ != -1) {
            this.setVerticalFormat(this.verticalFormat_);
        }
    }

    public void lineFeed() throws IOException {
        this.addToBuffer(LF);
    }

    public void newLine() throws IOException {
        this.addToBuffer(NL);
    }

    public void relativeHorizontalPosition(int chars) throws IOException {
        byte[] cmd = RHPP;
        if (chars < 0 || chars > 255) {
            String arg = "chars (" + String.valueOf(chars) + ")";
            throw new ExtendedIllegalArgumentException(arg, 2);
        }
        if (!this.pageStarted_) {
            this.initPage();
        }
        cmd[cmd.length - 1] = (byte)chars;
        this.addToBuffer(cmd);
    }

    public void relativeVerticalPosition(int lines) throws IOException {
        byte[] cmd = RVPP;
        if (lines < 0 || lines > 255) {
            String arg = "lines (" + String.valueOf(lines) + ")";
            throw new ExtendedIllegalArgumentException(arg, 2);
        }
        if (!this.pageStarted_) {
            this.initPage();
        }
        cmd[cmd.length - 1] = (byte)lines;
        this.addToBuffer(cmd);
    }

    private void sendSGEA() throws IOException {
        this.addToBuffer(SGEA);
    }

    public void setHorizontalFormat(int NumOfChars) throws IOException {
        byte[] cmd = new byte[]{0, 0, 0, 0};
        if (NumOfChars < 0 || NumOfChars > 255) {
            String arg = "NumOfChars (" + String.valueOf(NumOfChars) + ")";
            throw new ExtendedIllegalArgumentException(arg, 2);
        }
        this.horizontalFormat_ = NumOfChars;
        System.arraycopy(SHF, 0, cmd, 0, cmd.length - 1);
        cmd[cmd.length - 1] = (byte)NumOfChars;
        this.addToBuffer(cmd);
    }

    public void setVerticalFormat(int NumOfLines) throws IOException {
        byte[] cmd = new byte[]{0, 0, 0, 0};
        if (NumOfLines < 0 || NumOfLines > 255) {
            String arg = "NumOfLines (" + String.valueOf(NumOfLines) + ")";
            throw new ExtendedIllegalArgumentException(arg, 2);
        }
        this.verticalFormat_ = NumOfLines;
        System.arraycopy(SVF, 0, cmd, 0, cmd.length - 1);
        cmd[cmd.length - 1] = (byte)NumOfLines;
        this.addToBuffer(cmd);
    }

    @Override
    public void write(char[] databuffer, int offset, int length) throws IOException {
        String aStr = new String(databuffer, offset, length);
        this.write(aStr);
    }

    @Override
    public void write(int c) throws IOException {
        String aStr = String.valueOf(c);
        this.write(aStr);
    }

    @Override
    public void write(String str) throws IOException {
        byte[] convertedBytes;
        if (this.outPut == null) {
            throw new IOException("Stream closed");
        }
        if (!this.pageStarted_) {
            this.initPage();
        }
        if (this.dataLength + (convertedBytes = this.cvt.stringToByteArray(str)).length > this.buffer.length) {
            this.flush();
            if (convertedBytes.length > this.buffer.length) {
                this.outPut.write(convertedBytes, 0, convertedBytes.length);
                return;
            }
        }
        System.arraycopy(convertedBytes, 0, this.buffer, this.dataLength, convertedBytes.length);
        this.dataLength += convertedBytes.length;
    }

    @Override
    public void write(String str, int offset, int length) throws IOException {
        String aStr = str.substring(offset, offset + length);
        this.write(aStr);
    }
}

