/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.api.command;

import com.clickhouse.client.api.ClientException;
import com.clickhouse.client.api.metrics.OperationMetrics;
import com.clickhouse.client.api.query.QueryResponse;

public class CommandResponse
implements AutoCloseable {
    private final QueryResponse response;

    public CommandResponse(QueryResponse response) {
        this.response = response;
        try {
            response.close();
        }
        catch (Exception e) {
            throw new ClientException("Failed to close underlying resource", e);
        }
    }

    public OperationMetrics getMetrics() {
        return this.response.getMetrics();
    }

    public long getReadRows() {
        return this.response.getReadRows();
    }

    public long getReadBytes() {
        return this.response.getReadBytes();
    }

    public long getWrittenRows() {
        return this.response.getWrittenRows();
    }

    public long getWrittenBytes() {
        return this.response.getWrittenBytes();
    }

    public long getServerTime() {
        return this.response.getServerTime();
    }

    @Override
    public void close() throws Exception {
        this.response.close();
    }
}

