/*
 * Decompiled with CFR 0.152.
 */
package com.google.analytics.data.v1beta;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AudienceExportName
implements ResourceName {
    private static final PathTemplate PROPERTY_AUDIENCE_EXPORT = PathTemplate.createWithoutUrlEncoding((String)"properties/{property}/audienceExports/{audience_export}");
    private volatile Map<String, String> fieldValuesMap;
    private final String property;
    private final String audienceExport;

    @Deprecated
    protected AudienceExportName() {
        this.property = null;
        this.audienceExport = null;
    }

    private AudienceExportName(Builder builder) {
        this.property = (String)Preconditions.checkNotNull((Object)builder.getProperty());
        this.audienceExport = (String)Preconditions.checkNotNull((Object)builder.getAudienceExport());
    }

    public String getProperty() {
        return this.property;
    }

    public String getAudienceExport() {
        return this.audienceExport;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static AudienceExportName of(String property, String audienceExport) {
        return AudienceExportName.newBuilder().setProperty(property).setAudienceExport(audienceExport).build();
    }

    public static String format(String property, String audienceExport) {
        return AudienceExportName.newBuilder().setProperty(property).setAudienceExport(audienceExport).build().toString();
    }

    public static AudienceExportName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROPERTY_AUDIENCE_EXPORT.validatedMatch(formattedString, "AudienceExportName.parse: formattedString not in valid format");
        return AudienceExportName.of((String)matchMap.get("property"), (String)matchMap.get("audience_export"));
    }

    public static List<AudienceExportName> parseList(List<String> formattedStrings) {
        ArrayList<AudienceExportName> list = new ArrayList<AudienceExportName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AudienceExportName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AudienceExportName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AudienceExportName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROPERTY_AUDIENCE_EXPORT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AudienceExportName audienceExportName = this;
            synchronized (audienceExportName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.property != null) {
                        fieldMapBuilder.put((Object)"property", (Object)this.property);
                    }
                    if (this.audienceExport != null) {
                        fieldMapBuilder.put((Object)"audience_export", (Object)this.audienceExport);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROPERTY_AUDIENCE_EXPORT.instantiate(new String[]{"property", this.property, "audience_export", this.audienceExport});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            AudienceExportName that = (AudienceExportName)o;
            return Objects.equals(this.property, that.property) && Objects.equals(this.audienceExport, that.audienceExport);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.property);
        h *= 1000003;
        return h ^= Objects.hashCode(this.audienceExport);
    }

    public static class Builder {
        private String property;
        private String audienceExport;

        protected Builder() {
        }

        public String getProperty() {
            return this.property;
        }

        public String getAudienceExport() {
            return this.audienceExport;
        }

        public Builder setProperty(String property) {
            this.property = property;
            return this;
        }

        public Builder setAudienceExport(String audienceExport) {
            this.audienceExport = audienceExport;
            return this;
        }

        private Builder(AudienceExportName audienceExportName) {
            this.property = audienceExportName.property;
            this.audienceExport = audienceExportName.audienceExport;
        }

        public AudienceExportName build() {
            return new AudienceExportName(this);
        }
    }
}

