/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.cloud.bigquery.FormatOptions;
import com.google.common.base.MoreObjects;
import java.util.Objects;

public final class AvroOptions
extends FormatOptions {
    private static final long serialVersionUID = 2293570529308612712L;
    private final Boolean useAvroLogicalTypes;

    private AvroOptions(Builder builder) {
        super("AVRO");
        this.useAvroLogicalTypes = builder.useAvroLogicalTypes;
    }

    public Boolean useAvroLogicalTypes() {
        return this.useAvroLogicalTypes;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.getType()).add("useAvroLogicalTypes", (Object)this.useAvroLogicalTypes).toString();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getType(), this.useAvroLogicalTypes);
    }

    @Override
    public boolean equals(Object obj) {
        return obj == this || obj instanceof AvroOptions && Objects.equals(this.toPb(), ((AvroOptions)obj).toPb());
    }

    com.google.api.services.bigquery.model.AvroOptions toPb() {
        com.google.api.services.bigquery.model.AvroOptions avroOptions = new com.google.api.services.bigquery.model.AvroOptions();
        avroOptions.setUseAvroLogicalTypes(this.useAvroLogicalTypes);
        return avroOptions;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    static AvroOptions fromPb(com.google.api.services.bigquery.model.AvroOptions avroOptions) {
        Builder builder = AvroOptions.newBuilder();
        if (avroOptions.getUseAvroLogicalTypes() != null) {
            builder.setUseAvroLogicalTypes(avroOptions.getUseAvroLogicalTypes());
        }
        return builder.build();
    }

    public static final class Builder {
        private Boolean useAvroLogicalTypes;

        private Builder() {
        }

        private Builder(AvroOptions avroOptions) {
            this.useAvroLogicalTypes = avroOptions.useAvroLogicalTypes;
        }

        public Builder setUseAvroLogicalTypes(boolean useAvroLogicalTypes) {
            this.useAvroLogicalTypes = useAvroLogicalTypes;
            return this;
        }

        public AvroOptions build() {
            return new AvroOptions(this);
        }
    }
}

