/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.stone.UnionSerializer;
import com.dropbox.core.v2.files.UserGeneratedTag;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public final class TagObject {
    public static final TagObject OTHER = new TagObject().withTag(Tag.OTHER);
    private Tag _tag;
    private UserGeneratedTag userGeneratedTagValue;

    private TagObject() {
    }

    private TagObject withTag(Tag _tag) {
        TagObject result = new TagObject();
        result._tag = _tag;
        return result;
    }

    private TagObject withTagAndUserGeneratedTag(Tag _tag, UserGeneratedTag userGeneratedTagValue) {
        TagObject result = new TagObject();
        result._tag = _tag;
        result.userGeneratedTagValue = userGeneratedTagValue;
        return result;
    }

    public Tag tag() {
        return this._tag;
    }

    public boolean isUserGeneratedTag() {
        return this._tag == Tag.USER_GENERATED_TAG;
    }

    public static TagObject userGeneratedTag(UserGeneratedTag value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new TagObject().withTagAndUserGeneratedTag(Tag.USER_GENERATED_TAG, value);
    }

    public UserGeneratedTag getUserGeneratedTagValue() {
        if (this._tag != Tag.USER_GENERATED_TAG) {
            throw new IllegalStateException("Invalid tag: required Tag.USER_GENERATED_TAG, but was Tag." + this._tag.name());
        }
        return this.userGeneratedTagValue;
    }

    public boolean isOther() {
        return this._tag == Tag.OTHER;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this._tag, this.userGeneratedTagValue});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof TagObject) {
            TagObject other = (TagObject)obj;
            if (this._tag != other._tag) {
                return false;
            }
            switch (this._tag) {
                case USER_GENERATED_TAG: {
                    return this.userGeneratedTagValue == other.userGeneratedTagValue || this.userGeneratedTagValue.equals(other.userGeneratedTagValue);
                }
                case OTHER: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends UnionSerializer<TagObject> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(TagObject value, JsonGenerator g) throws IOException, JsonGenerationException {
            switch (value.tag()) {
                case USER_GENERATED_TAG: {
                    g.writeStartObject();
                    this.writeTag("user_generated_tag", g);
                    UserGeneratedTag.Serializer.INSTANCE.serialize(value.userGeneratedTagValue, g, true);
                    g.writeEndObject();
                    break;
                }
                default: {
                    g.writeString("other");
                }
            }
        }

        @Override
        public TagObject deserialize(JsonParser p) throws IOException, JsonParseException {
            TagObject value;
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            if ("user_generated_tag".equals(tag)) {
                UserGeneratedTag fieldValue = null;
                fieldValue = UserGeneratedTag.Serializer.INSTANCE.deserialize(p, true);
                value = TagObject.userGeneratedTag(fieldValue);
            } else {
                value = OTHER;
            }
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static enum Tag {
        USER_GENERATED_TAG,
        OTHER;

    }
}

