/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.hopgui.perspective.explorer.file.types;

import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.file.IHasFilename;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.hopgui.context.IGuiContextHandler;
import org.apache.hop.ui.hopgui.file.IHopFileType;
import org.apache.hop.ui.hopgui.file.IHopFileTypeHandler;
import org.apache.hop.ui.hopgui.file.empty.EmptyHopFileTypeHandler;

public class GenericFileType
implements IHopFileType {
    @Override
    public String getName() {
        return "Generic File";
    }

    @Override
    public String getDefaultFileExtension() {
        return "";
    }

    @Override
    public String[] getFilterExtensions() {
        return new String[0];
    }

    @Override
    public String[] getFilterNames() {
        return new String[0];
    }

    @Override
    public Properties getCapabilities() {
        return new Properties();
    }

    @Override
    public boolean hasCapability(String capability) {
        return false;
    }

    @Override
    public IHopFileTypeHandler openFile(HopGui hopGui, String filename, IVariables parentVariableSpace) throws HopException {
        return new EmptyHopFileTypeHandler();
    }

    @Override
    public IHopFileTypeHandler newFile(HopGui hopGui, IVariables parentVariableSpace) throws HopException {
        return new EmptyHopFileTypeHandler();
    }

    @Override
    public boolean isHandledBy(String filename, boolean checkContent) throws HopException {
        try {
            return HopVfs.getFileObject((String)filename).isFile();
        }
        catch (Exception e) {
            throw new HopException("Error seeing if file '" + filename + "' is a generic file", (Throwable)e);
        }
    }

    @Override
    public boolean supportsFile(IHasFilename metaObject) {
        return false;
    }

    @Override
    public List<IGuiContextHandler> getContextHandlers() {
        return Collections.emptyList();
    }

    @Override
    public String getFileTypeImage() {
        return "ui/images/file.svg";
    }
}

