/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.webapp.util;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientHandler;
import com.sun.jersey.client.urlconnection.HttpURLConnectionFactory;
import com.sun.jersey.client.urlconnection.URLConnectionClientHandler;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.authentication.client.AuthenticatedURL;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.security.authentication.client.Authenticator;
import org.apache.hadoop.security.authentication.client.ConnectionConfigurator;
import org.apache.hadoop.security.authentication.client.KerberosAuthenticator;
import org.apache.hadoop.security.ssl.SSLFactory;
import org.apache.hadoop.yarn.conf.YarnConfiguration;

public class WebServiceClient {
    private static SSLFactory sslFactory = null;
    private static volatile WebServiceClient instance = null;
    private static boolean isHttps = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void initialize(Configuration conf) throws Exception {
        if (instance != null) return;
        Class<WebServiceClient> clazz = WebServiceClient.class;
        synchronized (WebServiceClient.class) {
            if (instance != null) return;
            isHttps = YarnConfiguration.useHttps((Configuration)conf);
            if (isHttps) {
                WebServiceClient.createSSLFactory(conf);
            }
            instance = new WebServiceClient();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static WebServiceClient getWebServiceClient() {
        return instance;
    }

    @VisibleForTesting
    SSLFactory getSSLFactory() {
        return sslFactory;
    }

    private static SSLFactory createSSLFactory(Configuration conf) throws Exception {
        sslFactory = new SSLFactory(SSLFactory.Mode.CLIENT, conf);
        sslFactory.init();
        return sslFactory;
    }

    public Client createClient() {
        return new Client((ClientHandler)new URLConnectionClientHandler(this.getHttpURLConnectionFactory()));
    }

    @VisibleForTesting
    protected HttpURLConnectionFactory getHttpURLConnectionFactory() {
        return new HttpURLConnectionFactory(){

            public HttpURLConnection getHttpURLConnection(URL url) throws IOException {
                AuthenticatedURL.Token token = new AuthenticatedURL.Token();
                HttpURLConnection conn = null;
                try {
                    HttpURLConnection.setFollowRedirects(false);
                    conn = isHttps ? new AuthenticatedURL((Authenticator)new KerberosAuthenticator(), (ConnectionConfigurator)sslFactory).openConnection(url, token) : new AuthenticatedURL().openConnection(url, token);
                }
                catch (AuthenticationException e) {
                    throw new IOException(e);
                }
                return conn;
            }
        };
    }

    public static synchronized void destroy() {
        if (sslFactory != null) {
            sslFactory.destroy();
        }
        instance = null;
    }
}

