/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.dynamodb;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.beam.sdk.coders.AtomicCoder;
import org.apache.beam.sdk.coders.BooleanCoder;
import org.apache.beam.sdk.coders.ByteArrayCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.ListCoder;
import org.apache.beam.sdk.coders.MapCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import software.amazon.awssdk.core.BytesWrapper;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;

public class AttributeValueCoder
extends AtomicCoder<AttributeValue> {
    private static final @UnknownKeyFor @NonNull @Initialized AttributeValueCoder INSTANCE = new AttributeValueCoder();
    private static final @UnknownKeyFor @NonNull @Initialized ListCoder<@UnknownKeyFor @NonNull @Initialized String> LIST_STRING_CODER = ListCoder.of((Coder)StringUtf8Coder.of());
    private static final @UnknownKeyFor @NonNull @Initialized ListCoder<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> LIST_BYTE_CODER = ListCoder.of((Coder)ByteArrayCoder.of());
    private static final @UnknownKeyFor @NonNull @Initialized ListCoder<@UnknownKeyFor @NonNull @Initialized AttributeValue> LIST_ATTRIBUTE_CODER = ListCoder.of((Coder)AttributeValueCoder.of());
    private static final @UnknownKeyFor @NonNull @Initialized MapCoder<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized AttributeValue> MAP_ATTRIBUTE_CODER = MapCoder.of((Coder)StringUtf8Coder.of(), (Coder)AttributeValueCoder.of());

    private AttributeValueCoder() {
    }

    public static @UnknownKeyFor @NonNull @Initialized AttributeValueCoder of() {
        return INSTANCE;
    }

    public void encode(@UnknownKeyFor @NonNull @Initialized AttributeValue value, @UnknownKeyFor @NonNull @Initialized OutputStream outStream) throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (value.s() != null) {
            StringUtf8Coder.of().encode(AttributeValueType.s.toString(), outStream);
            StringUtf8Coder.of().encode(value.s(), outStream);
        } else if (value.n() != null) {
            StringUtf8Coder.of().encode(AttributeValueType.n.toString(), outStream);
            StringUtf8Coder.of().encode(value.n(), outStream);
        } else if (value.bool() != null) {
            StringUtf8Coder.of().encode(AttributeValueType.bool.toString(), outStream);
            BooleanCoder.of().encode(value.bool(), outStream);
        } else if (value.b() != null) {
            StringUtf8Coder.of().encode(AttributeValueType.b.toString(), outStream);
            ByteArrayCoder.of().encode(value.b().asByteArray(), outStream);
        } else if (value.ss() != null && value.ss().size() > 0) {
            StringUtf8Coder.of().encode(AttributeValueType.ss.toString(), outStream);
            LIST_STRING_CODER.encode((Iterable)value.ss(), outStream);
        } else if (value.ns() != null && value.ns().size() > 0) {
            StringUtf8Coder.of().encode(AttributeValueType.ns.toString(), outStream);
            LIST_STRING_CODER.encode((Iterable)value.ns(), outStream);
        } else if (value.bs() != null && value.bs().size() > 0) {
            StringUtf8Coder.of().encode(AttributeValueType.bs.toString(), outStream);
            LIST_BYTE_CODER.encode(this.convertToListByteArray(value.bs()), outStream);
        } else if (value.l() != null && value.l().size() > 0) {
            StringUtf8Coder.of().encode(AttributeValueType.l.toString(), outStream);
            LIST_ATTRIBUTE_CODER.encode((Iterable)value.l(), outStream);
        } else if (value.m() != null && value.m().size() > 0) {
            StringUtf8Coder.of().encode(AttributeValueType.m.toString(), outStream);
            MAP_ATTRIBUTE_CODER.encode(value.m(), outStream);
        } else if (value.nul() != null) {
            StringUtf8Coder.of().encode(AttributeValueType.nul.toString(), outStream);
            BooleanCoder.of().encode(value.nul(), outStream);
        } else {
            throw new CoderException("Unknown Type");
        }
    }

    public @UnknownKeyFor @NonNull @Initialized AttributeValue decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream) throws @UnknownKeyFor @NonNull @Initialized IOException {
        AttributeValue.Builder attrBuilder = AttributeValue.builder();
        String type = StringUtf8Coder.of().decode(inStream);
        AttributeValueType attrType = AttributeValueType.valueOf(type);
        switch (attrType) {
            case s: {
                attrBuilder.s(StringUtf8Coder.of().decode(inStream));
                break;
            }
            case n: {
                attrBuilder.n(StringUtf8Coder.of().decode(inStream));
                break;
            }
            case bool: {
                attrBuilder.bool(BooleanCoder.of().decode(inStream));
                break;
            }
            case b: {
                attrBuilder.b(SdkBytes.fromByteArray((byte[])ByteArrayCoder.of().decode(inStream)));
                break;
            }
            case ss: {
                attrBuilder.ss((Collection)LIST_STRING_CODER.decode(inStream));
                break;
            }
            case ns: {
                attrBuilder.ns((Collection)LIST_STRING_CODER.decode(inStream));
                break;
            }
            case bs: {
                attrBuilder.bs(this.convertToListByteBuffer((List)LIST_BYTE_CODER.decode(inStream)));
                break;
            }
            case l: {
                attrBuilder.l((Collection)LIST_ATTRIBUTE_CODER.decode(inStream));
                break;
            }
            case m: {
                attrBuilder.m(MAP_ATTRIBUTE_CODER.decode(inStream));
                break;
            }
            case nul: {
                attrBuilder.nul(BooleanCoder.of().decode(inStream));
                break;
            }
            default: {
                throw new CoderException("Unknown Type");
            }
        }
        return (AttributeValue)attrBuilder.build();
    }

    private @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> convertToListByteArray(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized SdkBytes> listSdkByte) {
        return listSdkByte.stream().map(BytesWrapper::asByteArray).collect(Collectors.toList());
    }

    private @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized SdkBytes> convertToListByteBuffer(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> listByteArr) {
        return listByteArr.stream().map(SdkBytes::fromByteArray).collect(Collectors.toList());
    }

    private static enum AttributeValueType {
        s,
        n,
        b,
        ss,
        ns,
        bs,
        m,
        l,
        bool,
        nul;

    }
}

