/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.kinesis;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.apache.beam.repackaged.core.org.apache.commons.lang3.RandomStringUtils;
import org.apache.beam.sdk.io.aws2.kinesis.EFOShardSubscriber;
import org.apache.beam.sdk.io.aws2.kinesis.KinesisReaderCheckpoint;
import org.apache.beam.sdk.io.aws2.kinesis.KinesisRecord;
import org.apache.beam.sdk.io.aws2.kinesis.ShardCheckpoint;
import org.apache.beam.sdk.io.aws2.kinesis.StartingPoint;
import org.apache.beam.sdk.io.aws2.kinesis.TimeUtil;
import org.apache.beam.sdk.io.aws2.kinesis.WatermarkPolicy;
import org.apache.beam.sdk.io.aws2.kinesis.WatermarkPolicyFactory;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ForwardingIterator;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Lists;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.kinesis.KinesisAsyncClient;
import software.amazon.awssdk.services.kinesis.model.ChildShard;
import software.amazon.awssdk.services.kinesis.model.ShardIteratorType;
import software.amazon.awssdk.services.kinesis.model.StartingPosition;
import software.amazon.awssdk.services.kinesis.model.SubscribeToShardEvent;
import software.amazon.kinesis.common.InitialPositionInStream;
import software.amazon.kinesis.retrieval.AggregatorUtil;
import software.amazon.kinesis.retrieval.KinesisClientRecord;

class EFOShardSubscribersPool {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(EFOShardSubscribersPool.class);
    private static final @UnknownKeyFor @NonNull @Initialized int ON_ERROR_COOL_DOWN_MS_DEFAULT = 1000;
    private static final @UnknownKeyFor @NonNull @Initialized int DEFAULT_MAX_CAPACITY_PER_SHARD = 10;
    private final @UnknownKeyFor @NonNull @Initialized int onErrorCoolDownMs;
    private final @UnknownKeyFor @NonNull @Initialized String poolId;
    private final  @UnknownKeyFor @NonNull @Initialized KinesisIO.Read read;
    private final @UnknownKeyFor @NonNull @Initialized String consumerArn;
    private final @UnknownKeyFor @NonNull @Initialized KinesisAsyncClient kinesis;
    private final @UnknownKeyFor @NonNull @Initialized ConcurrentLinkedQueue<@UnknownKeyFor @NonNull @Initialized EventRecords> eventQueue = new ConcurrentLinkedQueue();
    private final @UnknownKeyFor @NonNull @Initialized int maxCapacityPerShard;
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized ShardState> state = new HashMap<String, ShardState>();
    private volatile @MonotonicNonNull @UnknownKeyFor @Initialized Throwable subscriptionError;
    private @UnknownKeyFor @NonNull @Initialized boolean isStopped = false;
    private final @UnknownKeyFor @NonNull @Initialized BiConsumer<@UnknownKeyFor @Nullable @Initialized Void, @UnknownKeyFor @NonNull @Initialized Throwable> errorHandler = (unused, error) -> {
        if (error != null && this.subscriptionError == null) {
            this.subscriptionError = error;
        }
    };
    private final @UnknownKeyFor @NonNull @Initialized ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
    @Nullable @UnknownKeyFor @Initialized EventRecords current = null;
    private final @UnknownKeyFor @NonNull @Initialized WatermarkPolicyFactory watermarkPolicyFactory;

    EFOShardSubscribersPool( @UnknownKeyFor @NonNull @Initialized KinesisIO.Read readSpec, @UnknownKeyFor @NonNull @Initialized String consumerArn, @UnknownKeyFor @NonNull @Initialized KinesisAsyncClient kinesis) {
        this(readSpec, consumerArn, kinesis, 1000);
    }

    EFOShardSubscribersPool( @UnknownKeyFor @NonNull @Initialized KinesisIO.Read readSpec, @UnknownKeyFor @NonNull @Initialized String consumerArn, @UnknownKeyFor @NonNull @Initialized KinesisAsyncClient kinesis, @UnknownKeyFor @NonNull @Initialized int onErrorCoolDownMs) {
        this.poolId = EFOShardSubscribersPool.generatePoolId();
        this.read = readSpec;
        this.consumerArn = consumerArn;
        this.kinesis = kinesis;
        this.watermarkPolicyFactory = this.read.getWatermarkPolicyFactory();
        this.onErrorCoolDownMs = onErrorCoolDownMs;
        this.maxCapacityPerShard = readSpec.getMaxCapacityPerShard() != null ? this.read.getMaxCapacityPerShard() : 10;
    }

    void start(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized ShardCheckpoint> checkpoints) {
        LOG.info("Pool {} - starting for stream {} consumer {}. Checkpoints = {}", new Object[]{this.poolId, this.read.getStreamName(), this.consumerArn, checkpoints});
        for (ShardCheckpoint shardCheckpoint : checkpoints) {
            org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkState((!this.state.containsKey(shardCheckpoint.getShardId()) ? 1 : 0) != 0, (String)"Duplicate shard id %s", (Object)shardCheckpoint.getShardId());
            ShardState shardState = new ShardState(this.initShardSubscriber(shardCheckpoint), shardCheckpoint, this.watermarkPolicyFactory);
            this.state.put(shardCheckpoint.getShardId(), shardState);
        }
    }

    @Nullable @UnknownKeyFor @Initialized KinesisRecord getNextRecord() throws @UnknownKeyFor @NonNull @Initialized IOException {
        while (true) {
            if (!this.isStopped && this.subscriptionError != null) {
                this.stop();
            }
            if (this.current == null) {
                this.current = this.eventQueue.poll();
            }
            if (this.current == null) break;
            String shardId = this.current.shardId;
            ShardState shardState = (ShardState)Preconditions.checkStateNotNull((Object)this.state.get(shardId));
            if (this.current.hasNext()) {
                KinesisRecord kinesisRecord;
                KinesisClientRecord r = (KinesisClientRecord)this.current.next();
                if (!this.current.hasNext()) {
                    this.onEventDone(shardState, this.current);
                    this.current = null;
                }
                if (!shardState.isAfterInitialCheckpoint(kinesisRecord = new KinesisRecord(r, this.read.getStreamName(), shardId))) continue;
                shardState.update(kinesisRecord);
                return kinesisRecord;
            }
            this.onEventDone(shardState, this.current);
            this.current = null;
        }
        if (this.subscriptionError != null) {
            this.stop();
            throw new IOException(this.subscriptionError);
        }
        return null;
    }

    private void onEventDone(@UnknownKeyFor @NonNull @Initialized ShardState shardState, @UnknownKeyFor @NonNull @Initialized EventRecords eventContainer) {
        SubscribeToShardEvent event = eventContainer.event;
        if (event.continuationSequenceNumber() == null && event.hasChildShards()) {
            LOG.info("Pool {} - processing re-shard signal {}", (Object)this.poolId, (Object)event);
            List<String> successorShardsIds = this.computeSuccessorShardsIds(eventContainer);
            for (String successorShardId : successorShardsIds) {
                ShardCheckpoint newCheckpoint = new ShardCheckpoint(this.read.getStreamName(), successorShardId, new StartingPoint(InitialPositionInStream.TRIM_HORIZON));
                this.state.computeIfAbsent(successorShardId, id -> new ShardState(this.initShardSubscriber(newCheckpoint), newCheckpoint, this.watermarkPolicyFactory));
            }
            this.state.remove(eventContainer.shardId);
        } else {
            shardState.update(eventContainer);
        }
    }

    private @UnknownKeyFor @NonNull @Initialized EFOShardSubscriber initShardSubscriber(@UnknownKeyFor @NonNull @Initialized ShardCheckpoint cp) {
        EFOShardSubscriber subscriber = new EFOShardSubscriber(this, cp.getShardId(), this.consumerArn, this.kinesis, this.onErrorCoolDownMs);
        StartingPosition startingPosition = cp.toEFOStartingPosition();
        if (this.subscriptionError == null) {
            subscriber.subscribe(startingPosition).whenCompleteAsync((BiConsumer)this.errorHandler);
        }
        return subscriber;
    }

    private @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> computeSuccessorShardsIds(@UnknownKeyFor @NonNull @Initialized EventRecords eventContainer) {
        ArrayList<String> successorShardsIds = new ArrayList<String>();
        SubscribeToShardEvent event = eventContainer.event;
        for (ChildShard childShard : event.childShards()) {
            if (!childShard.parentShards().contains(eventContainer.shardId)) continue;
            if (childShard.parentShards().size() > 1) {
                String maxParentId = (String)childShard.parentShards().stream().max(String::compareTo).get();
                if (!eventContainer.shardId.equals(maxParentId)) continue;
                successorShardsIds.add(childShard.shardId());
                continue;
            }
            successorShardsIds.add(childShard.shardId());
        }
        if (successorShardsIds.isEmpty()) {
            LOG.info("Pool {} - found no successors for shard {}", (Object)this.poolId, (Object)eventContainer.shardId);
        } else {
            LOG.info("Pool {} - found successors for shard {}: {}", new Object[]{this.poolId, eventContainer.shardId, successorShardsIds});
        }
        return successorShardsIds;
    }

    void enqueueEvent(@UnknownKeyFor @NonNull @Initialized String shardId, @UnknownKeyFor @NonNull @Initialized SubscribeToShardEvent event) {
        this.eventQueue.offer(new EventRecords(shardId, event));
    }

    @UnknownKeyFor @NonNull @Initialized Instant getWatermark() {
        return TimeUtil.minTimestamp(this.state.values().stream().map(ShardState::getWatermark));
    }

    @UnknownKeyFor @NonNull @Initialized KinesisReaderCheckpoint getCheckpointMark() {
        ArrayList<ShardCheckpoint> checkpoints = new ArrayList<ShardCheckpoint>(this.state.size());
        for (ShardState shardState : this.state.values()) {
            checkpoints.add(shardState.toCheckpoint());
        }
        return new KinesisReaderCheckpoint(checkpoints);
    }

    void stop() {
        LOG.info("Pool {} - stopping", (Object)this.poolId);
        this.isStopped = true;
        this.state.forEach((shardId, st) -> st.subscriber.cancel());
        this.scheduler.shutdownNow();
    }

    @UnknownKeyFor @NonNull @Initialized String getPoolId() {
        return this.poolId;
    }

    @UnknownKeyFor @NonNull @Initialized int getMaxCapacityPerShard() {
        return this.maxCapacityPerShard;
    }

    <T> @UnknownKeyFor @NonNull @Initialized CompletableFuture<T> delayedTask(@UnknownKeyFor @NonNull @Initialized Supplier<@UnknownKeyFor @NonNull @Initialized CompletableFuture<T>> task, @UnknownKeyFor @NonNull @Initialized long delayMs) {
        if (delayMs <= 0L) {
            return task.get();
        }
        CompletableFuture cf = new CompletableFuture();
        try {
            this.scheduler.schedule(() -> ((CompletableFuture)task.get()).handle((t, e) -> e == null ? cf.complete(t) : cf.completeExceptionally((Throwable)e)), delayMs, TimeUnit.MILLISECONDS);
        }
        catch (RejectedExecutionException e) {
            cf.completeExceptionally(e);
        }
        return cf;
    }

    private static @UnknownKeyFor @NonNull @Initialized String generatePoolId() {
        return RandomStringUtils.randomAlphanumeric((int)8).toLowerCase();
    }

    private static class EventRecords
    extends ForwardingIterator<KinesisClientRecord> {
        private static final @UnknownKeyFor @NonNull @Initialized AggregatorUtil AGG_UTIL = new AggregatorUtil();
        @UnknownKeyFor @NonNull @Initialized String shardId;
        @UnknownKeyFor @NonNull @Initialized SubscribeToShardEvent event;
        @MonotonicNonNull @UnknownKeyFor @Initialized Iterator<@UnknownKeyFor @NonNull @Initialized KinesisClientRecord> delegate = null;

        EventRecords(@UnknownKeyFor @NonNull @Initialized String shardId, @UnknownKeyFor @NonNull @Initialized SubscribeToShardEvent event) {
            this.shardId = shardId;
            this.event = event;
        }

        protected @UnknownKeyFor @NonNull @Initialized Iterator<@UnknownKeyFor @NonNull @Initialized KinesisClientRecord> delegate() {
            if (this.delegate == null) {
                this.delegate = this.event.hasRecords() && !this.event.records().isEmpty() ? AGG_UTIL.deaggregate(Lists.transform((List)this.event.records(), KinesisClientRecord::fromRecord)).iterator() : Collections.emptyIterator();
            }
            return this.delegate;
        }
    }

    private static class ShardState {
        final @UnknownKeyFor @NonNull @Initialized EFOShardSubscriber subscriber;
        final @UnknownKeyFor @NonNull @Initialized ShardCheckpoint initCheckpoint;
        final @UnknownKeyFor @NonNull @Initialized WatermarkPolicy watermarkPolicy;
        @Nullable @UnknownKeyFor @Initialized String sequenceNumber = null;
        @UnknownKeyFor @NonNull @Initialized long subSequenceNumber = 0L;

        ShardState(@UnknownKeyFor @NonNull @Initialized EFOShardSubscriber subscriber, @UnknownKeyFor @NonNull @Initialized ShardCheckpoint initCheckpoint, @UnknownKeyFor @NonNull @Initialized WatermarkPolicyFactory watermarkPolicyFactory) {
            this.subscriber = subscriber;
            this.initCheckpoint = initCheckpoint;
            this.watermarkPolicy = watermarkPolicyFactory.createWatermarkPolicy();
        }

        void update(@UnknownKeyFor @NonNull @Initialized KinesisRecord r) {
            this.sequenceNumber = (String)org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkNotNull((Object)r.getSequenceNumber());
            this.subSequenceNumber = r.getSubSequenceNumber();
            this.watermarkPolicy.update(r);
        }

        void update(@UnknownKeyFor @NonNull @Initialized EventRecords eventRecords) {
            this.sequenceNumber = (String)org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkNotNull((Object)eventRecords.event.continuationSequenceNumber());
            this.subscriber.ackEvent();
        }

        @UnknownKeyFor @NonNull @Initialized ShardCheckpoint toCheckpoint() {
            if (this.sequenceNumber != null) {
                return new ShardCheckpoint(this.initCheckpoint.getStreamName(), this.initCheckpoint.getShardId(), ShardIteratorType.AFTER_SEQUENCE_NUMBER, this.sequenceNumber, this.subSequenceNumber);
            }
            return this.initCheckpoint;
        }

        @UnknownKeyFor @NonNull @Initialized Instant getWatermark() {
            return this.watermarkPolicy.getWatermark();
        }

        @UnknownKeyFor @NonNull @Initialized boolean isAfterInitialCheckpoint(@UnknownKeyFor @NonNull @Initialized KinesisRecord r) {
            return this.initCheckpoint.isBeforeOrAt(r);
        }
    }
}

